// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A placement strategy that determines how to place the tasks for the service.
 */
class AwsEcsServicePlacementStrategiesDetails private constructor(builder: Builder) {
    /**
     * The field to apply the placement strategy against.
     *
     * For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`.
     *
     * For the `binpack` placement strategy, valid values are `cpu` and `memory`.
     *
     * For the `random` placement strategy, this attribute is not used.
     */
    val field: kotlin.String? = builder.field
    /**
     * The type of placement strategy.
     *
     * The `random` placement strategy randomly places tasks on available candidates.
     *
     * The `spread` placement strategy spreads placement across available candidates evenly based on the value of `Field`.
     *
     * The `binpack` strategy places tasks on available candidates that have the least available amount of the resource that is specified in `Field`.
     *
     * Valid values: `random` | `spread` | `binpack`
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsServicePlacementStrategiesDetails(")
        append("field=$field,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsServicePlacementStrategiesDetails

        if (field != other.field) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The field to apply the placement strategy against.
         *
         * For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`.
         *
         * For the `binpack` placement strategy, valid values are `cpu` and `memory`.
         *
         * For the `random` placement strategy, this attribute is not used.
         */
        var field: kotlin.String? = null
        /**
         * The type of placement strategy.
         *
         * The `random` placement strategy randomly places tasks on available candidates.
         *
         * The `spread` placement strategy spreads placement across available candidates evenly based on the value of `Field`.
         *
         * The `binpack` strategy places tasks on available candidates that have the least available amount of the resource that is specified in `Field`.
         *
         * Valid values: `random` | `spread` | `binpack`
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails) : this() {
            this.field = x.field
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails = AwsEcsServicePlacementStrategiesDetails(this)
    }
}
