// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an Amazon EC2 VPN connection.
 */
class AwsEc2VpnConnectionDetails private constructor(builder: Builder) {
    /**
     * The category of the VPN connection. `VPN` indicates an Amazon Web Services VPN connection. `VPN-Classic` indicates an Amazon Web Services Classic VPN connection.
     */
    val category: kotlin.String? = builder.category
    /**
     * The configuration information for the VPN connection's customer gateway, in the native XML format.
     */
    val customerGatewayConfiguration: kotlin.String? = builder.customerGatewayConfiguration
    /**
     * The identifier of the customer gateway that is at your end of the VPN connection.
     */
    val customerGatewayId: kotlin.String? = builder.customerGatewayId
    /**
     * The VPN connection options.
     */
    val options: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails? = builder.options
    /**
     * The static routes that are associated with the VPN connection.
     */
    val routes: List<AwsEc2VpnConnectionRoutesDetails>? = builder.routes
    /**
     * The current state of the VPN connection.
     */
    val state: kotlin.String? = builder.state
    /**
     * The identifier of the transit gateway that is associated with the VPN connection.
     */
    val transitGatewayId: kotlin.String? = builder.transitGatewayId
    /**
     * The type of VPN connection.
     */
    val type: kotlin.String? = builder.type
    /**
     * Information about the VPN tunnel.
     */
    val vgwTelemetry: List<AwsEc2VpnConnectionVgwTelemetryDetails>? = builder.vgwTelemetry
    /**
     * The identifier of the VPN connection.
     */
    val vpnConnectionId: kotlin.String? = builder.vpnConnectionId
    /**
     * The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN connection.
     */
    val vpnGatewayId: kotlin.String? = builder.vpnGatewayId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VpnConnectionDetails(")
        append("category=$category,")
        append("customerGatewayConfiguration=$customerGatewayConfiguration,")
        append("customerGatewayId=$customerGatewayId,")
        append("options=$options,")
        append("routes=$routes,")
        append("state=$state,")
        append("transitGatewayId=$transitGatewayId,")
        append("type=$type,")
        append("vgwTelemetry=$vgwTelemetry,")
        append("vpnConnectionId=$vpnConnectionId,")
        append("vpnGatewayId=$vpnGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (customerGatewayConfiguration?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayId?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (routes?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vgwTelemetry?.hashCode() ?: 0)
        result = 31 * result + (vpnConnectionId?.hashCode() ?: 0)
        result = 31 * result + (vpnGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VpnConnectionDetails

        if (category != other.category) return false
        if (customerGatewayConfiguration != other.customerGatewayConfiguration) return false
        if (customerGatewayId != other.customerGatewayId) return false
        if (options != other.options) return false
        if (routes != other.routes) return false
        if (state != other.state) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (type != other.type) return false
        if (vgwTelemetry != other.vgwTelemetry) return false
        if (vpnConnectionId != other.vpnConnectionId) return false
        if (vpnGatewayId != other.vpnGatewayId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The category of the VPN connection. `VPN` indicates an Amazon Web Services VPN connection. `VPN-Classic` indicates an Amazon Web Services Classic VPN connection.
         */
        var category: kotlin.String? = null
        /**
         * The configuration information for the VPN connection's customer gateway, in the native XML format.
         */
        var customerGatewayConfiguration: kotlin.String? = null
        /**
         * The identifier of the customer gateway that is at your end of the VPN connection.
         */
        var customerGatewayId: kotlin.String? = null
        /**
         * The VPN connection options.
         */
        var options: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails? = null
        /**
         * The static routes that are associated with the VPN connection.
         */
        var routes: List<AwsEc2VpnConnectionRoutesDetails>? = null
        /**
         * The current state of the VPN connection.
         */
        var state: kotlin.String? = null
        /**
         * The identifier of the transit gateway that is associated with the VPN connection.
         */
        var transitGatewayId: kotlin.String? = null
        /**
         * The type of VPN connection.
         */
        var type: kotlin.String? = null
        /**
         * Information about the VPN tunnel.
         */
        var vgwTelemetry: List<AwsEc2VpnConnectionVgwTelemetryDetails>? = null
        /**
         * The identifier of the VPN connection.
         */
        var vpnConnectionId: kotlin.String? = null
        /**
         * The identifier of the virtual private gateway that is at the Amazon Web Services side of the VPN connection.
         */
        var vpnGatewayId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails) : this() {
            this.category = x.category
            this.customerGatewayConfiguration = x.customerGatewayConfiguration
            this.customerGatewayId = x.customerGatewayId
            this.options = x.options
            this.routes = x.routes
            this.state = x.state
            this.transitGatewayId = x.transitGatewayId
            this.type = x.type
            this.vgwTelemetry = x.vgwTelemetry
            this.vpnConnectionId = x.vpnConnectionId
            this.vpnGatewayId = x.vpnGatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails = AwsEc2VpnConnectionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsDetails.invoke(block)
        }
    }
}
