// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains details about the service configuration for a VPC endpoint service.
 */
class AwsEc2VpcEndpointServiceDetails private constructor(builder: Builder) {
    /**
     * Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
     */
    val acceptanceRequired: kotlin.Boolean = builder.acceptanceRequired
    /**
     * The Availability Zones where the service is available.
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The DNS names for the service.
     */
    val baseEndpointDnsNames: List<String>? = builder.baseEndpointDnsNames
    /**
     * The ARNs of the Gateway Load Balancers for the service.
     */
    val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * Whether the service manages its VPC endpoints.
     */
    val managesVpcEndpoints: kotlin.Boolean = builder.managesVpcEndpoints
    /**
     * The ARNs of the Network Load Balancers for the service.
     */
    val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * The private DNS name for the service.
     */
    val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The identifier of the service.
     */
    val serviceId: kotlin.String? = builder.serviceId
    /**
     * The name of the service.
     */
    val serviceName: kotlin.String? = builder.serviceName
    /**
     * The current state of the service.
     */
    val serviceState: kotlin.String? = builder.serviceState
    /**
     * The types for the service.
     */
    val serviceType: List<AwsEc2VpcEndpointServiceServiceTypeDetails>? = builder.serviceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VpcEndpointServiceDetails(")
        append("acceptanceRequired=$acceptanceRequired,")
        append("availabilityZones=$availabilityZones,")
        append("baseEndpointDnsNames=$baseEndpointDnsNames,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("managesVpcEndpoints=$managesVpcEndpoints,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("privateDnsName=$privateDnsName,")
        append("serviceId=$serviceId,")
        append("serviceName=$serviceName,")
        append("serviceState=$serviceState,")
        append("serviceType=$serviceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptanceRequired.hashCode()
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (baseEndpointDnsNames?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (managesVpcEndpoints.hashCode())
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceState?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VpcEndpointServiceDetails

        if (acceptanceRequired != other.acceptanceRequired) return false
        if (availabilityZones != other.availabilityZones) return false
        if (baseEndpointDnsNames != other.baseEndpointDnsNames) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (managesVpcEndpoints != other.managesVpcEndpoints) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (privateDnsName != other.privateDnsName) return false
        if (serviceId != other.serviceId) return false
        if (serviceName != other.serviceName) return false
        if (serviceState != other.serviceState) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.
         */
        var acceptanceRequired: kotlin.Boolean = false
        /**
         * The Availability Zones where the service is available.
         */
        var availabilityZones: List<String>? = null
        /**
         * The DNS names for the service.
         */
        var baseEndpointDnsNames: List<String>? = null
        /**
         * The ARNs of the Gateway Load Balancers for the service.
         */
        var gatewayLoadBalancerArns: List<String>? = null
        /**
         * Whether the service manages its VPC endpoints.
         */
        var managesVpcEndpoints: kotlin.Boolean = false
        /**
         * The ARNs of the Network Load Balancers for the service.
         */
        var networkLoadBalancerArns: List<String>? = null
        /**
         * The private DNS name for the service.
         */
        var privateDnsName: kotlin.String? = null
        /**
         * The identifier of the service.
         */
        var serviceId: kotlin.String? = null
        /**
         * The name of the service.
         */
        var serviceName: kotlin.String? = null
        /**
         * The current state of the service.
         */
        var serviceState: kotlin.String? = null
        /**
         * The types for the service.
         */
        var serviceType: List<AwsEc2VpcEndpointServiceServiceTypeDetails>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails) : this() {
            this.acceptanceRequired = x.acceptanceRequired
            this.availabilityZones = x.availabilityZones
            this.baseEndpointDnsNames = x.baseEndpointDnsNames
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.managesVpcEndpoints = x.managesVpcEndpoints
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.privateDnsName = x.privateDnsName
            this.serviceId = x.serviceId
            this.serviceName = x.serviceName
            this.serviceState = x.serviceState
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails = AwsEc2VpcEndpointServiceDetails(this)
    }
}
