// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an EC2 volume.
 */
class AwsEc2VolumeDetails private constructor(builder: Builder) {
    /**
     * The volume attachments.
     */
    val attachments: List<AwsEc2VolumeAttachment>? = builder.attachments
    /**
     * Indicates when the volume was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createTime: kotlin.String? = builder.createTime
    /**
     * The device name for the volume that is attached to the instance.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * Specifies whether the volume is encrypted.
     */
    val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The size of the volume, in GiBs.
     */
    val size: kotlin.Int = builder.size
    /**
     * The snapshot from which the volume was created.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume state.
     */
    val status: kotlin.String? = builder.status
    /**
     * The ID of the volume.
     */
    val volumeId: kotlin.String? = builder.volumeId
    /**
     * Indicates whether the volume was scanned or skipped.
     */
    val volumeScanStatus: kotlin.String? = builder.volumeScanStatus
    /**
     * The volume type.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VolumeDetails(")
        append("attachments=$attachments,")
        append("createTime=$createTime,")
        append("deviceName=$deviceName,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("size=$size,")
        append("snapshotId=$snapshotId,")
        append("status=$status,")
        append("volumeId=$volumeId,")
        append("volumeScanStatus=$volumeScanStatus,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (size)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeScanStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VolumeDetails

        if (attachments != other.attachments) return false
        if (createTime != other.createTime) return false
        if (deviceName != other.deviceName) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (size != other.size) return false
        if (snapshotId != other.snapshotId) return false
        if (status != other.status) return false
        if (volumeId != other.volumeId) return false
        if (volumeScanStatus != other.volumeScanStatus) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The volume attachments.
         */
        var attachments: List<AwsEc2VolumeAttachment>? = null
        /**
         * Indicates when the volume was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createTime: kotlin.String? = null
        /**
         * The device name for the volume that is attached to the instance.
         */
        var deviceName: kotlin.String? = null
        /**
         * Specifies whether the volume is encrypted.
         */
        var encrypted: kotlin.Boolean = false
        /**
         * The ARN of the KMS key that was used to protect the volume encryption key for the volume.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The size of the volume, in GiBs.
         */
        var size: kotlin.Int = 0
        /**
         * The snapshot from which the volume was created.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The volume state.
         */
        var status: kotlin.String? = null
        /**
         * The ID of the volume.
         */
        var volumeId: kotlin.String? = null
        /**
         * Indicates whether the volume was scanned or skipped.
         */
        var volumeScanStatus: kotlin.String? = null
        /**
         * The volume type.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails) : this() {
            this.attachments = x.attachments
            this.createTime = x.createTime
            this.deviceName = x.deviceName
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.size = x.size
            this.snapshotId = x.snapshotId
            this.status = x.status
            this.volumeId = x.volumeId
            this.volumeScanStatus = x.volumeScanStatus
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails = AwsEc2VolumeDetails(this)
    }
}
