// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A rule for the network ACL. Each rule allows or denies access based on the IP address, traffic direction, port, and protocol.
 */
class AwsEc2NetworkAclEntry private constructor(builder: Builder) {
    /**
     * The IPV4 network range for which to deny or allow access.
     */
    val cidrBlock: kotlin.String? = builder.cidrBlock
    /**
     * Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the subnet.
     */
    val egress: kotlin.Boolean = builder.egress
    /**
     * The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
     */
    val icmpTypeCode: aws.sdk.kotlin.services.securityhub.model.IcmpTypeCode? = builder.icmpTypeCode
    /**
     * The IPV6 network range for which to deny or allow access.
     */
    val ipv6CidrBlock: kotlin.String? = builder.ipv6CidrBlock
    /**
     * For TCP or UDP protocols, the range of ports that the rule applies to.
     */
    val portRange: aws.sdk.kotlin.services.securityhub.model.PortRangeFromTo? = builder.portRange
    /**
     * The protocol that the rule applies to. To deny or allow access to all protocols, use the value `-1`.
     */
    val protocol: kotlin.String? = builder.protocol
    /**
     * Whether the rule is used to allow access or deny access.
     */
    val ruleAction: kotlin.String? = builder.ruleAction
    /**
     * The rule number. The rules are processed in order by their number.
     */
    val ruleNumber: kotlin.Int = builder.ruleNumber

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2NetworkAclEntry(")
        append("cidrBlock=$cidrBlock,")
        append("egress=$egress,")
        append("icmpTypeCode=$icmpTypeCode,")
        append("ipv6CidrBlock=$ipv6CidrBlock,")
        append("portRange=$portRange,")
        append("protocol=$protocol,")
        append("ruleAction=$ruleAction,")
        append("ruleNumber=$ruleNumber)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (egress.hashCode())
        result = 31 * result + (icmpTypeCode?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (portRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (ruleAction?.hashCode() ?: 0)
        result = 31 * result + (ruleNumber)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2NetworkAclEntry

        if (cidrBlock != other.cidrBlock) return false
        if (egress != other.egress) return false
        if (icmpTypeCode != other.icmpTypeCode) return false
        if (ipv6CidrBlock != other.ipv6CidrBlock) return false
        if (portRange != other.portRange) return false
        if (protocol != other.protocol) return false
        if (ruleAction != other.ruleAction) return false
        if (ruleNumber != other.ruleNumber) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IPV4 network range for which to deny or allow access.
         */
        var cidrBlock: kotlin.String? = null
        /**
         * Whether the rule is an egress rule. An egress rule is a rule that applies to traffic that leaves the subnet.
         */
        var egress: kotlin.Boolean = false
        /**
         * The Internet Control Message Protocol (ICMP) type and code for which to deny or allow access.
         */
        var icmpTypeCode: aws.sdk.kotlin.services.securityhub.model.IcmpTypeCode? = null
        /**
         * The IPV6 network range for which to deny or allow access.
         */
        var ipv6CidrBlock: kotlin.String? = null
        /**
         * For TCP or UDP protocols, the range of ports that the rule applies to.
         */
        var portRange: aws.sdk.kotlin.services.securityhub.model.PortRangeFromTo? = null
        /**
         * The protocol that the rule applies to. To deny or allow access to all protocols, use the value `-1`.
         */
        var protocol: kotlin.String? = null
        /**
         * Whether the rule is used to allow access or deny access.
         */
        var ruleAction: kotlin.String? = null
        /**
         * The rule number. The rules are processed in order by their number.
         */
        var ruleNumber: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclEntry) : this() {
            this.cidrBlock = x.cidrBlock
            this.egress = x.egress
            this.icmpTypeCode = x.icmpTypeCode
            this.ipv6CidrBlock = x.ipv6CidrBlock
            this.portRange = x.portRange
            this.protocol = x.protocol
            this.ruleAction = x.ruleAction
            this.ruleNumber = x.ruleNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclEntry = AwsEc2NetworkAclEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.IcmpTypeCode] inside the given [block]
         */
        fun icmpTypeCode(block: aws.sdk.kotlin.services.securityhub.model.IcmpTypeCode.Builder.() -> kotlin.Unit) {
            this.icmpTypeCode = aws.sdk.kotlin.services.securityhub.model.IcmpTypeCode.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.PortRangeFromTo] inside the given [block]
         */
        fun portRange(block: aws.sdk.kotlin.services.securityhub.model.PortRangeFromTo.Builder.() -> kotlin.Unit) {
            this.portRange = aws.sdk.kotlin.services.securityhub.model.PortRangeFromTo.invoke(block)
        }
    }
}
