// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains details about an Amazon EC2 network access control list (ACL).
 */
class AwsEc2NetworkAclDetails private constructor(builder: Builder) {
    /**
     * Associations between the network ACL and subnets.
     */
    val associations: List<AwsEc2NetworkAclAssociation>? = builder.associations
    /**
     * The set of rules in the network ACL.
     */
    val entries: List<AwsEc2NetworkAclEntry>? = builder.entries
    /**
     * Whether this is the default network ACL for the VPC.
     */
    val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The identifier of the network ACL.
     */
    val networkAclId: kotlin.String? = builder.networkAclId
    /**
     * The identifier of the Amazon Web Services account that owns the network ACL.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The identifier of the VPC for the network ACL.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2NetworkAclDetails(")
        append("associations=$associations,")
        append("entries=$entries,")
        append("isDefault=$isDefault,")
        append("networkAclId=$networkAclId,")
        append("ownerId=$ownerId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (entries?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (networkAclId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2NetworkAclDetails

        if (associations != other.associations) return false
        if (entries != other.entries) return false
        if (isDefault != other.isDefault) return false
        if (networkAclId != other.networkAclId) return false
        if (ownerId != other.ownerId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Associations between the network ACL and subnets.
         */
        var associations: List<AwsEc2NetworkAclAssociation>? = null
        /**
         * The set of rules in the network ACL.
         */
        var entries: List<AwsEc2NetworkAclEntry>? = null
        /**
         * Whether this is the default network ACL for the VPC.
         */
        var isDefault: kotlin.Boolean = false
        /**
         * The identifier of the network ACL.
         */
        var networkAclId: kotlin.String? = null
        /**
         * The identifier of the Amazon Web Services account that owns the network ACL.
         */
        var ownerId: kotlin.String? = null
        /**
         * The identifier of the VPC for the network ACL.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails) : this() {
            this.associations = x.associations
            this.entries = x.entries
            this.isDefault = x.isDefault
            this.networkAclId = x.networkAclId
            this.ownerId = x.ownerId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails = AwsEc2NetworkAclDetails(this)
    }
}
