// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the provisioned throughput for the table or for a global secondary index.
 */
class AwsDynamoDbTableProvisionedThroughput private constructor(builder: Builder) {
    /**
     * Indicates when the provisioned throughput was last decreased.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val lastDecreaseDateTime: kotlin.String? = builder.lastDecreaseDateTime
    /**
     * Indicates when the provisioned throughput was last increased.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val lastIncreaseDateTime: kotlin.String? = builder.lastIncreaseDateTime
    /**
     * The number of times during the current UTC calendar day that the provisioned throughput was decreased.
     */
    val numberOfDecreasesToday: kotlin.Int = builder.numberOfDecreasesToday
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    val readCapacityUnits: kotlin.Int = builder.readCapacityUnits
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    val writeCapacityUnits: kotlin.Int = builder.writeCapacityUnits

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDynamoDbTableProvisionedThroughput(")
        append("lastDecreaseDateTime=$lastDecreaseDateTime,")
        append("lastIncreaseDateTime=$lastIncreaseDateTime,")
        append("numberOfDecreasesToday=$numberOfDecreasesToday,")
        append("readCapacityUnits=$readCapacityUnits,")
        append("writeCapacityUnits=$writeCapacityUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastDecreaseDateTime?.hashCode() ?: 0
        result = 31 * result + (lastIncreaseDateTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfDecreasesToday)
        result = 31 * result + (readCapacityUnits)
        result = 31 * result + (writeCapacityUnits)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDynamoDbTableProvisionedThroughput

        if (lastDecreaseDateTime != other.lastDecreaseDateTime) return false
        if (lastIncreaseDateTime != other.lastIncreaseDateTime) return false
        if (numberOfDecreasesToday != other.numberOfDecreasesToday) return false
        if (readCapacityUnits != other.readCapacityUnits) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates when the provisioned throughput was last decreased.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var lastDecreaseDateTime: kotlin.String? = null
        /**
         * Indicates when the provisioned throughput was last increased.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var lastIncreaseDateTime: kotlin.String? = null
        /**
         * The number of times during the current UTC calendar day that the provisioned throughput was decreased.
         */
        var numberOfDecreasesToday: kotlin.Int = 0
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        var readCapacityUnits: kotlin.Int = 0
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        var writeCapacityUnits: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput) : this() {
            this.lastDecreaseDateTime = x.lastDecreaseDateTime
            this.lastIncreaseDateTime = x.lastIncreaseDateTime
            this.numberOfDecreasesToday = x.numberOfDecreasesToday
            this.readCapacityUnits = x.readCapacityUnits
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableProvisionedThroughput = AwsDynamoDbTableProvisionedThroughput(this)
    }
}
