// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains the cross-origin resource sharing (CORS) configuration for the API. CORS is only supported for HTTP APIs.
 */
class AwsCorsConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether the CORS request includes credentials.
     */
    val allowCredentials: kotlin.Boolean = builder.allowCredentials
    /**
     * The allowed headers for CORS requests.
     */
    val allowHeaders: List<String>? = builder.allowHeaders
    /**
     * The allowed methods for CORS requests.
     */
    val allowMethods: List<String>? = builder.allowMethods
    /**
     * The allowed origins for CORS requests.
     */
    val allowOrigins: List<String>? = builder.allowOrigins
    /**
     * The exposed headers for CORS requests.
     */
    val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * The number of seconds for which the browser caches preflight request results.
     */
    val maxAge: kotlin.Int = builder.maxAge

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCorsConfiguration(")
        append("allowCredentials=$allowCredentials,")
        append("allowHeaders=$allowHeaders,")
        append("allowMethods=$allowMethods,")
        append("allowOrigins=$allowOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("maxAge=$maxAge)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowCredentials.hashCode()
        result = 31 * result + (allowHeaders?.hashCode() ?: 0)
        result = 31 * result + (allowMethods?.hashCode() ?: 0)
        result = 31 * result + (allowOrigins?.hashCode() ?: 0)
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (maxAge)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCorsConfiguration

        if (allowCredentials != other.allowCredentials) return false
        if (allowHeaders != other.allowHeaders) return false
        if (allowMethods != other.allowMethods) return false
        if (allowOrigins != other.allowOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (maxAge != other.maxAge) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the CORS request includes credentials.
         */
        var allowCredentials: kotlin.Boolean = false
        /**
         * The allowed headers for CORS requests.
         */
        var allowHeaders: List<String>? = null
        /**
         * The allowed methods for CORS requests.
         */
        var allowMethods: List<String>? = null
        /**
         * The allowed origins for CORS requests.
         */
        var allowOrigins: List<String>? = null
        /**
         * The exposed headers for CORS requests.
         */
        var exposeHeaders: List<String>? = null
        /**
         * The number of seconds for which the browser caches preflight request results.
         */
        var maxAge: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration) : this() {
            this.allowCredentials = x.allowCredentials
            this.allowHeaders = x.allowHeaders
            this.allowMethods = x.allowMethods
            this.allowOrigins = x.allowOrigins
            this.exposeHeaders = x.exposeHeaders
            this.maxAge = x.maxAge
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration = AwsCorsConfiguration(this)
    }
}
