// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the build input source code for this build project.
 */
class AwsCodeBuildProjectSource private constructor(builder: Builder) {
    /**
     * Information about the Git clone depth for the build project.
     */
    val gitCloneDepth: kotlin.Int = builder.gitCloneDepth
    /**
     * Whether to ignore SSL warnings while connecting to the project source code.
     */
    val insecureSsl: kotlin.Boolean = builder.insecureSsl
    /**
     * Information about the location of the source code to be built.
     *
     * Valid values include:
     * + For source code settings that are specified in the source action of a pipeline in CodePipeline, location should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.
     * + For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the build spec file (for example, `https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name` ).
     * + For source code in an S3 input bucket, one of the following.
     *    + The path to the ZIP file that contains the source code (for example, `bucket-name/path/to/object-name.zip`).
     *    +  The path to the folder that contains the source code (for example, `bucket-name/path/to/source-code/folder/`).
     * + For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the build spec file.
     * + For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the build spec file.
     */
    val location: kotlin.String? = builder.location
    /**
     * The type of repository that contains the source code to be built. Valid values are:
     * + `BITBUCKET` - The source code is in a Bitbucket repository.
     * + `CODECOMMIT` - The source code is in an CodeCommit repository.
     * + `CODEPIPELINE` - The source code settings are specified in the source action of a pipeline in CodePipeline.
     * + `GITHUB` - The source code is in a GitHub repository.
     * + `GITHUB_ENTERPRISE` - The source code is in a GitHub Enterprise repository.
     * + `NO_SOURCE` - The project does not have input source code.
     * + `S3` - The source code is in an S3 input bucket.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCodeBuildProjectSource(")
        append("gitCloneDepth=$gitCloneDepth,")
        append("insecureSsl=$insecureSsl,")
        append("location=$location,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gitCloneDepth
        result = 31 * result + (insecureSsl.hashCode())
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCodeBuildProjectSource

        if (gitCloneDepth != other.gitCloneDepth) return false
        if (insecureSsl != other.insecureSsl) return false
        if (location != other.location) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the Git clone depth for the build project.
         */
        var gitCloneDepth: kotlin.Int = 0
        /**
         * Whether to ignore SSL warnings while connecting to the project source code.
         */
        var insecureSsl: kotlin.Boolean = false
        /**
         * Information about the location of the source code to be built.
         *
         * Valid values include:
         * + For source code settings that are specified in the source action of a pipeline in CodePipeline, location should not be specified. If it is specified, CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source action instead of this value.
         * + For source code in an CodeCommit repository, the HTTPS clone URL to the repository that contains the source code and the build spec file (for example, `https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name` ).
         * + For source code in an S3 input bucket, one of the following.
         *    + The path to the ZIP file that contains the source code (for example, `bucket-name/path/to/object-name.zip`).
         *    +  The path to the folder that contains the source code (for example, `bucket-name/path/to/source-code/folder/`).
         * + For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the build spec file.
         * + For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the build spec file.
         */
        var location: kotlin.String? = null
        /**
         * The type of repository that contains the source code to be built. Valid values are:
         * + `BITBUCKET` - The source code is in a Bitbucket repository.
         * + `CODECOMMIT` - The source code is in an CodeCommit repository.
         * + `CODEPIPELINE` - The source code settings are specified in the source action of a pipeline in CodePipeline.
         * + `GITHUB` - The source code is in a GitHub repository.
         * + `GITHUB_ENTERPRISE` - The source code is in a GitHub Enterprise repository.
         * + `NO_SOURCE` - The project does not have input source code.
         * + `S3` - The source code is in an S3 input bucket.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource) : this() {
            this.gitCloneDepth = x.gitCloneDepth
            this.insecureSsl = x.insecureSsl
            this.location = x.location
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectSource = AwsCodeBuildProjectSource(this)
    }
}
