// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the build artifacts for the CodeBuild project.
 */
class AwsCodeBuildProjectArtifactsDetails private constructor(builder: Builder) {
    /**
     * An identifier for the artifact definition.
     */
    val artifactIdentifier: kotlin.String? = builder.artifactIdentifier
    /**
     * Indicates whether to disable encryption on the artifact. Only valid when `Type` is `S3`.
     */
    val encryptionDisabled: kotlin.Boolean = builder.encryptionDisabled
    /**
     * Only used when `Type` is `S3`. The name of the S3 bucket where the artifact is located.
     */
    val location: kotlin.String? = builder.location
    /**
     * Only used when Type is S3. The name of the artifact. Used with `NamepaceType` and `Path` to determine the pattern for storing the artifact.
     */
    val name: kotlin.String? = builder.name
    /**
     * Only used when `Type` is `S3`. The value to use for the namespace. Used with `Name` and `Path` to determine the pattern for storing the artifact.
     */
    val namespaceType: kotlin.String? = builder.namespaceType
    /**
     * Whether the name specified in the buildspec file overrides the artifact name.
     */
    val overrideArtifactName: kotlin.Boolean = builder.overrideArtifactName
    /**
     * Only used when `Type` is `S3`. The type of output artifact to create.
     */
    val packaging: kotlin.String? = builder.packaging
    /**
     * Only used when `Type` is `S3`. The path to the artifact. Used with `Name` and `NamespaceType` to determine the pattern for storing the artifact.
     */
    val path: kotlin.String? = builder.path
    /**
     * The type of build artifact.
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCodeBuildProjectArtifactsDetails(")
        append("artifactIdentifier=$artifactIdentifier,")
        append("encryptionDisabled=$encryptionDisabled,")
        append("location=$location,")
        append("name=$name,")
        append("namespaceType=$namespaceType,")
        append("overrideArtifactName=$overrideArtifactName,")
        append("packaging=$packaging,")
        append("path=$path,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactIdentifier?.hashCode() ?: 0
        result = 31 * result + (encryptionDisabled.hashCode())
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespaceType?.hashCode() ?: 0)
        result = 31 * result + (overrideArtifactName.hashCode())
        result = 31 * result + (packaging?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCodeBuildProjectArtifactsDetails

        if (artifactIdentifier != other.artifactIdentifier) return false
        if (encryptionDisabled != other.encryptionDisabled) return false
        if (location != other.location) return false
        if (name != other.name) return false
        if (namespaceType != other.namespaceType) return false
        if (overrideArtifactName != other.overrideArtifactName) return false
        if (packaging != other.packaging) return false
        if (path != other.path) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * An identifier for the artifact definition.
         */
        var artifactIdentifier: kotlin.String? = null
        /**
         * Indicates whether to disable encryption on the artifact. Only valid when `Type` is `S3`.
         */
        var encryptionDisabled: kotlin.Boolean = false
        /**
         * Only used when `Type` is `S3`. The name of the S3 bucket where the artifact is located.
         */
        var location: kotlin.String? = null
        /**
         * Only used when Type is S3. The name of the artifact. Used with `NamepaceType` and `Path` to determine the pattern for storing the artifact.
         */
        var name: kotlin.String? = null
        /**
         * Only used when `Type` is `S3`. The value to use for the namespace. Used with `Name` and `Path` to determine the pattern for storing the artifact.
         */
        var namespaceType: kotlin.String? = null
        /**
         * Whether the name specified in the buildspec file overrides the artifact name.
         */
        var overrideArtifactName: kotlin.Boolean = false
        /**
         * Only used when `Type` is `S3`. The type of output artifact to create.
         */
        var packaging: kotlin.String? = null
        /**
         * Only used when `Type` is `S3`. The path to the artifact. Used with `Name` and `NamespaceType` to determine the pattern for storing the artifact.
         */
        var path: kotlin.String? = null
        /**
         * The type of build artifact.
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails) : this() {
            this.artifactIdentifier = x.artifactIdentifier
            this.encryptionDisabled = x.encryptionDisabled
            this.location = x.location
            this.name = x.name
            this.namespaceType = x.namespaceType
            this.overrideArtifactName = x.overrideArtifactName
            this.packaging = x.packaging
            this.path = x.path
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails = AwsCodeBuildProjectArtifactsDetails(this)
    }
}
