// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the TLS/SSL configuration that the CloudFront distribution uses to communicate with viewers.
 */
class AwsCloudFrontDistributionViewerCertificate private constructor(builder: Builder) {
    /**
     * The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM certificate ARN, you must also provide `MinimumCertificateVersion` and `SslSupportMethod`.
     */
    val acmCertificateArn: kotlin.String? = builder.acmCertificateArn
    /**
     * The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
     */
    val certificate: kotlin.String? = builder.certificate
    /**
     * The source of the certificate identified by `Certificate`. Note that in CloudFront, this attribute is deprecated.
     */
    val certificateSource: kotlin.String? = builder.certificateSource
    /**
     * Whether the distribution uses the CloudFront domain name. If set to `false`, then you provide either `AcmCertificateArn` or `IamCertificateId`.
     */
    val cloudFrontDefaultCertificate: kotlin.Boolean = builder.cloudFrontDefaultCertificate
    /**
     * The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide `IamCertificateId`, then you also must provide `MinimumProtocolVersion` and `SslSupportMethod`.
     */
    val iamCertificateId: kotlin.String? = builder.iamCertificateId
    /**
     * The security policy that CloudFront uses for HTTPS connections with viewers. If `SslSupportMethod` is `sni-only`, then `MinimumProtocolVersion` must be `TLSv1` or higher.
     */
    val minimumProtocolVersion: kotlin.String? = builder.minimumProtocolVersion
    /**
     * The viewers that the distribution accepts HTTPS connections from.
     */
    val sslSupportMethod: kotlin.String? = builder.sslSupportMethod

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCloudFrontDistributionViewerCertificate(")
        append("acmCertificateArn=$acmCertificateArn,")
        append("certificate=$certificate,")
        append("certificateSource=$certificateSource,")
        append("cloudFrontDefaultCertificate=$cloudFrontDefaultCertificate,")
        append("iamCertificateId=$iamCertificateId,")
        append("minimumProtocolVersion=$minimumProtocolVersion,")
        append("sslSupportMethod=$sslSupportMethod)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acmCertificateArn?.hashCode() ?: 0
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (certificateSource?.hashCode() ?: 0)
        result = 31 * result + (cloudFrontDefaultCertificate.hashCode())
        result = 31 * result + (iamCertificateId?.hashCode() ?: 0)
        result = 31 * result + (minimumProtocolVersion?.hashCode() ?: 0)
        result = 31 * result + (sslSupportMethod?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCloudFrontDistributionViewerCertificate

        if (acmCertificateArn != other.acmCertificateArn) return false
        if (certificate != other.certificate) return false
        if (certificateSource != other.certificateSource) return false
        if (cloudFrontDefaultCertificate != other.cloudFrontDefaultCertificate) return false
        if (iamCertificateId != other.iamCertificateId) return false
        if (minimumProtocolVersion != other.minimumProtocolVersion) return false
        if (sslSupportMethod != other.sslSupportMethod) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the ACM certificate. Used if the certificate is stored in ACM. If you provide an ACM certificate ARN, you must also provide `MinimumCertificateVersion` and `SslSupportMethod`.
         */
        var acmCertificateArn: kotlin.String? = null
        /**
         * The identifier of the certificate. Note that in CloudFront, this attribute is deprecated.
         */
        var certificate: kotlin.String? = null
        /**
         * The source of the certificate identified by `Certificate`. Note that in CloudFront, this attribute is deprecated.
         */
        var certificateSource: kotlin.String? = null
        /**
         * Whether the distribution uses the CloudFront domain name. If set to `false`, then you provide either `AcmCertificateArn` or `IamCertificateId`.
         */
        var cloudFrontDefaultCertificate: kotlin.Boolean = false
        /**
         * The identifier of the IAM certificate. Used if the certificate is stored in IAM. If you provide `IamCertificateId`, then you also must provide `MinimumProtocolVersion` and `SslSupportMethod`.
         */
        var iamCertificateId: kotlin.String? = null
        /**
         * The security policy that CloudFront uses for HTTPS connections with viewers. If `SslSupportMethod` is `sni-only`, then `MinimumProtocolVersion` must be `TLSv1` or higher.
         */
        var minimumProtocolVersion: kotlin.String? = null
        /**
         * The viewers that the distribution accepts HTTPS connections from.
         */
        var sslSupportMethod: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate) : this() {
            this.acmCertificateArn = x.acmCertificateArn
            this.certificate = x.certificate
            this.certificateSource = x.certificateSource
            this.cloudFrontDefaultCertificate = x.cloudFrontDefaultCertificate
            this.iamCertificateId = x.iamCertificateId
            this.minimumProtocolVersion = x.minimumProtocolVersion
            this.sslSupportMethod = x.sslSupportMethod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate = AwsCloudFrontDistributionViewerCertificate(this)
    }
}
