// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A complex type that describes the Amazon S3 bucket, HTTP server (for example, a web server), AWS Elemental MediaStore, or other server from which CloudFront gets your files.
 */
class AwsCloudFrontDistributionOriginItem private constructor(builder: Builder) {
    /**
     * An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website hosting, use the `S3OriginConfig` type instead.
     */
    val customOriginConfig: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig? = builder.customOriginConfig
    /**
     * Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this origin.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * A unique identifier for the origin or origin group.
     */
    val id: kotlin.String? = builder.id
    /**
     * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
     */
    val originPath: kotlin.String? = builder.originPath
    /**
     * An origin that is an S3 bucket that is not configured with static website hosting.
     */
    val s3OriginConfig: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig? = builder.s3OriginConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCloudFrontDistributionOriginItem(")
        append("customOriginConfig=$customOriginConfig,")
        append("domainName=$domainName,")
        append("id=$id,")
        append("originPath=$originPath,")
        append("s3OriginConfig=$s3OriginConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customOriginConfig?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (originPath?.hashCode() ?: 0)
        result = 31 * result + (s3OriginConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCloudFrontDistributionOriginItem

        if (customOriginConfig != other.customOriginConfig) return false
        if (domainName != other.domainName) return false
        if (id != other.id) return false
        if (originPath != other.originPath) return false
        if (s3OriginConfig != other.s3OriginConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website hosting, use the `S3OriginConfig` type instead.
         */
        var customOriginConfig: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig? = null
        /**
         * Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this origin.
         */
        var domainName: kotlin.String? = null
        /**
         * A unique identifier for the origin or origin group.
         */
        var id: kotlin.String? = null
        /**
         * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or your custom origin.
         */
        var originPath: kotlin.String? = null
        /**
         * An origin that is an S3 bucket that is not configured with static website hosting.
         */
        var s3OriginConfig: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginItem) : this() {
            this.customOriginConfig = x.customOriginConfig
            this.domainName = x.domainName
            this.id = x.id
            this.originPath = x.originPath
            this.s3OriginConfig = x.s3OriginConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginItem = AwsCloudFrontDistributionOriginItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig] inside the given [block]
         */
        fun customOriginConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig.Builder.() -> kotlin.Unit) {
            this.customOriginConfig = aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig] inside the given [block]
         */
        fun s3OriginConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.Builder.() -> kotlin.Unit) {
            this.s3OriginConfig = aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig.invoke(block)
        }
    }
}
