// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A custom origin. A custom origin is any origin that is not an Amazon S3 bucket, with one exception. An Amazon S3 bucket that is [configured with static website hosting](https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html) is a custom origin.
 */
class AwsCloudFrontDistributionOriginCustomOriginConfig private constructor(builder: Builder) {
    /**
     * The HTTP port that CloudFront uses to connect to the origin.
     */
    val httpPort: kotlin.Int = builder.httpPort
    /**
     * The HTTPS port that CloudFront uses to connect to the origin.
     */
    val httpsPort: kotlin.Int = builder.httpsPort
    /**
     * Specifies how long, in seconds, CloudFront persists its connection to the origin.
     */
    val originKeepaliveTimeout: kotlin.Int = builder.originKeepaliveTimeout
    /**
     * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
     */
    val originProtocolPolicy: kotlin.String? = builder.originProtocolPolicy
    /**
     * Specifies how long, in seconds, CloudFront waits for a response from the origin.
     */
    val originReadTimeout: kotlin.Int = builder.originReadTimeout
    /**
     * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
     */
    val originSslProtocols: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols? = builder.originSslProtocols

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCloudFrontDistributionOriginCustomOriginConfig(")
        append("httpPort=$httpPort,")
        append("httpsPort=$httpsPort,")
        append("originKeepaliveTimeout=$originKeepaliveTimeout,")
        append("originProtocolPolicy=$originProtocolPolicy,")
        append("originReadTimeout=$originReadTimeout,")
        append("originSslProtocols=$originSslProtocols)")
    }

    override fun hashCode(): kotlin.Int {
        var result = httpPort
        result = 31 * result + (httpsPort)
        result = 31 * result + (originKeepaliveTimeout)
        result = 31 * result + (originProtocolPolicy?.hashCode() ?: 0)
        result = 31 * result + (originReadTimeout)
        result = 31 * result + (originSslProtocols?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCloudFrontDistributionOriginCustomOriginConfig

        if (httpPort != other.httpPort) return false
        if (httpsPort != other.httpsPort) return false
        if (originKeepaliveTimeout != other.originKeepaliveTimeout) return false
        if (originProtocolPolicy != other.originProtocolPolicy) return false
        if (originReadTimeout != other.originReadTimeout) return false
        if (originSslProtocols != other.originSslProtocols) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The HTTP port that CloudFront uses to connect to the origin.
         */
        var httpPort: kotlin.Int = 0
        /**
         * The HTTPS port that CloudFront uses to connect to the origin.
         */
        var httpsPort: kotlin.Int = 0
        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         */
        var originKeepaliveTimeout: kotlin.Int = 0
        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         */
        var originProtocolPolicy: kotlin.String? = null
        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin.
         */
        var originReadTimeout: kotlin.Int = 0
        /**
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
         */
        var originSslProtocols: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig) : this() {
            this.httpPort = x.httpPort
            this.httpsPort = x.httpsPort
            this.originKeepaliveTimeout = x.originKeepaliveTimeout
            this.originProtocolPolicy = x.originProtocolPolicy
            this.originReadTimeout = x.originReadTimeout
            this.originSslProtocols = x.originSslProtocols
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig = AwsCloudFrontDistributionOriginCustomOriginConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols] inside the given [block]
         */
        fun originSslProtocols(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.Builder.() -> kotlin.Unit) {
            this.originSslProtocols = aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.invoke(block)
        }
    }
}
