// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about the Certificate Manager managed renewal for an `AMAZON_ISSUED` certificate.
 */
class AwsCertificateManagerCertificateRenewalSummary private constructor(builder: Builder) {
    /**
     * Information about the validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal. Provided only when the certificate type is `AMAZON_ISSUED`.
     */
    val domainValidationOptions: List<AwsCertificateManagerCertificateDomainValidationOption>? = builder.domainValidationOptions
    /**
     * The status of the Certificate Manager managed renewal of the certificate.
     *
     * Valid values: `PENDING_AUTO_RENEWAL` | `PENDING_VALIDATION` | `SUCCESS` | `FAILED`
     */
    val renewalStatus: kotlin.String? = builder.renewalStatus
    /**
     * The reason that a renewal request was unsuccessful.
     *
     * Valid values: `NO_AVAILABLE_CONTACTS` | `ADDITIONAL_VERIFICATION_REQUIRED` | `DOMAIN_NOT_ALLOWED` | `INVALID_PUBLIC_DOMAIN` | `DOMAIN_VALIDATION_DENIED` | `CAA_ERROR` | `PCA_LIMIT_EXCEEDED` | `PCA_INVALID_ARN` | `PCA_INVALID_STATE` | `PCA_REQUEST_FAILED` | `PCA_NAME_CONSTRAINTS_VALIDATION` | `PCA_RESOURCE_NOT_FOUND` | `PCA_INVALID_ARGS` | `PCA_INVALID_DURATION` | `PCA_ACCESS_DENIED` | `SLR_NOT_FOUND` | `OTHER`
     */
    val renewalStatusReason: kotlin.String? = builder.renewalStatusReason
    /**
     * Indicates when the renewal summary was last updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val updatedAt: kotlin.String? = builder.updatedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCertificateManagerCertificateRenewalSummary(")
        append("domainValidationOptions=$domainValidationOptions,")
        append("renewalStatus=$renewalStatus,")
        append("renewalStatusReason=$renewalStatusReason,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainValidationOptions?.hashCode() ?: 0
        result = 31 * result + (renewalStatus?.hashCode() ?: 0)
        result = 31 * result + (renewalStatusReason?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCertificateManagerCertificateRenewalSummary

        if (domainValidationOptions != other.domainValidationOptions) return false
        if (renewalStatus != other.renewalStatus) return false
        if (renewalStatusReason != other.renewalStatusReason) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal. Provided only when the certificate type is `AMAZON_ISSUED`.
         */
        var domainValidationOptions: List<AwsCertificateManagerCertificateDomainValidationOption>? = null
        /**
         * The status of the Certificate Manager managed renewal of the certificate.
         *
         * Valid values: `PENDING_AUTO_RENEWAL` | `PENDING_VALIDATION` | `SUCCESS` | `FAILED`
         */
        var renewalStatus: kotlin.String? = null
        /**
         * The reason that a renewal request was unsuccessful.
         *
         * Valid values: `NO_AVAILABLE_CONTACTS` | `ADDITIONAL_VERIFICATION_REQUIRED` | `DOMAIN_NOT_ALLOWED` | `INVALID_PUBLIC_DOMAIN` | `DOMAIN_VALIDATION_DENIED` | `CAA_ERROR` | `PCA_LIMIT_EXCEEDED` | `PCA_INVALID_ARN` | `PCA_INVALID_STATE` | `PCA_REQUEST_FAILED` | `PCA_NAME_CONSTRAINTS_VALIDATION` | `PCA_RESOURCE_NOT_FOUND` | `PCA_INVALID_ARGS` | `PCA_INVALID_DURATION` | `PCA_ACCESS_DENIED` | `SLR_NOT_FOUND` | `OTHER`
         */
        var renewalStatusReason: kotlin.String? = null
        /**
         * Indicates when the renewal summary was last updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var updatedAt: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary) : this() {
            this.domainValidationOptions = x.domainValidationOptions
            this.renewalStatus = x.renewalStatus
            this.renewalStatusReason = x.renewalStatusReason
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary = AwsCertificateManagerCertificateRenewalSummary(this)
    }
}
