// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about one of the following:
 * + The initial validation of each domain name that occurs as a result of the `RequestCertificate` request
 * + The validation of each domain name in the certificate, as it pertains to Certificate Manager managed renewal
 */
class AwsCertificateManagerCertificateDomainValidationOption private constructor(builder: Builder) {
    /**
     * A fully qualified domain name (FQDN) in the certificate.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * The CNAME record that is added to the DNS database for domain validation.
     */
    val resourceRecord: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord? = builder.resourceRecord
    /**
     * The domain name that Certificate Manager uses to send domain validation emails.
     */
    val validationDomain: kotlin.String? = builder.validationDomain
    /**
     * A list of email addresses that Certificate Manager uses to send domain validation emails.
     */
    val validationEmails: List<String>? = builder.validationEmails
    /**
     * The method used to validate the domain name.
     */
    val validationMethod: kotlin.String? = builder.validationMethod
    /**
     * The validation status of the domain name.
     */
    val validationStatus: kotlin.String? = builder.validationStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCertificateManagerCertificateDomainValidationOption(")
        append("domainName=$domainName,")
        append("resourceRecord=$resourceRecord,")
        append("validationDomain=$validationDomain,")
        append("validationEmails=$validationEmails,")
        append("validationMethod=$validationMethod,")
        append("validationStatus=$validationStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainName?.hashCode() ?: 0
        result = 31 * result + (resourceRecord?.hashCode() ?: 0)
        result = 31 * result + (validationDomain?.hashCode() ?: 0)
        result = 31 * result + (validationEmails?.hashCode() ?: 0)
        result = 31 * result + (validationMethod?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCertificateManagerCertificateDomainValidationOption

        if (domainName != other.domainName) return false
        if (resourceRecord != other.resourceRecord) return false
        if (validationDomain != other.validationDomain) return false
        if (validationEmails != other.validationEmails) return false
        if (validationMethod != other.validationMethod) return false
        if (validationStatus != other.validationStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * A fully qualified domain name (FQDN) in the certificate.
         */
        var domainName: kotlin.String? = null
        /**
         * The CNAME record that is added to the DNS database for domain validation.
         */
        var resourceRecord: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord? = null
        /**
         * The domain name that Certificate Manager uses to send domain validation emails.
         */
        var validationDomain: kotlin.String? = null
        /**
         * A list of email addresses that Certificate Manager uses to send domain validation emails.
         */
        var validationEmails: List<String>? = null
        /**
         * The method used to validate the domain name.
         */
        var validationMethod: kotlin.String? = null
        /**
         * The validation status of the domain name.
         */
        var validationStatus: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption) : this() {
            this.domainName = x.domainName
            this.resourceRecord = x.resourceRecord
            this.validationDomain = x.validationDomain
            this.validationEmails = x.validationEmails
            this.validationMethod = x.validationMethod
            this.validationStatus = x.validationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption = AwsCertificateManagerCertificateDomainValidationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord] inside the given [block]
         */
        fun resourceRecord(block: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord.Builder.() -> kotlin.Unit) {
            this.resourceRecord = aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateResourceRecord.invoke(block)
        }
    }
}
