// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Certificate Manager certificate.
 */
class AwsCertificateManagerCertificateDetails private constructor(builder: Builder) {
    /**
     * The ARN of the private certificate authority (CA) that will be used to issue the certificate.
     */
    val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Indicates when the certificate was requested.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdAt: kotlin.String? = builder.createdAt
    /**
     * The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
     */
    val domainName: kotlin.String? = builder.domainName
    /**
     * Contains information about the initial validation of each domain name that occurs as a result of the `RequestCertificate` request.
     *
     * Only provided if the certificate type is `AMAZON_ISSUED`.
     */
    val domainValidationOptions: List<AwsCertificateManagerCertificateDomainValidationOption>? = builder.domainValidationOptions
    /**
     * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
     */
    val extendedKeyUsages: List<AwsCertificateManagerCertificateExtendedKeyUsage>? = builder.extendedKeyUsages
    /**
     * For a failed certificate request, the reason for the failure.
     *
     * Valid values: `NO_AVAILABLE_CONTACTS` | `ADDITIONAL_VERIFICATION_REQUIRED` | `DOMAIN_NOT_ALLOWED` | `INVALID_PUBLIC_DOMAIN` | `DOMAIN_VALIDATION_DENIED` | `CAA_ERROR` | `PCA_LIMIT_EXCEEDED` | `PCA_INVALID_ARN` | `PCA_INVALID_STATE` | `PCA_REQUEST_FAILED` | `PCA_NAME_CONSTRAINTS_VALIDATION` | `PCA_RESOURCE_NOT_FOUND` | `PCA_INVALID_ARGS` | `PCA_INVALID_DURATION` | `PCA_ACCESS_DENIED` | `SLR_NOT_FOUND` | `OTHER`
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * Indicates when the certificate was imported. Provided if the certificate type is `IMPORTED`.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val importedAt: kotlin.String? = builder.importedAt
    /**
     * The list of ARNs for the Amazon Web Services resources that use the certificate.
     */
    val inUseBy: List<String>? = builder.inUseBy
    /**
     * Indicates when the certificate was issued. Provided if the certificate type is `AMAZON_ISSUED`.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val issuedAt: kotlin.String? = builder.issuedAt
    /**
     * The name of the certificate authority that issued and signed the certificate.
     */
    val issuer: kotlin.String? = builder.issuer
    /**
     * The algorithm that was used to generate the public-private key pair.
     *
     * Valid values: `RSA_2048` | `RSA_1024` |` RSA_4096` | `EC_prime256v1` | `EC_secp384r1` | `EC_secp521r1`
     */
    val keyAlgorithm: kotlin.String? = builder.keyAlgorithm
    /**
     * A list of key usage X.509 v3 extension objects.
     */
    val keyUsages: List<AwsCertificateManagerCertificateKeyUsage>? = builder.keyUsages
    /**
     * The time after which the certificate becomes invalid.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val notAfter: kotlin.String? = builder.notAfter
    /**
     * The time before which the certificate is not valid.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val notBefore: kotlin.String? = builder.notBefore
    /**
     * Provides a value that specifies whether to add the certificate to a transparency log.
     */
    val options: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateOptions? = builder.options
    /**
     * Whether the certificate is eligible for renewal.
     *
     * Valid values: `ELIGIBLE` | `INELIGIBLE`
     */
    val renewalEligibility: kotlin.String? = builder.renewalEligibility
    /**
     * Information about the status of the Certificate Manager managed renewal for the certificate. Provided only when the certificate type is `AMAZON_ISSUED`.
     */
    val renewalSummary: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary? = builder.renewalSummary
    /**
     * The serial number of the certificate.
     */
    val serial: kotlin.String? = builder.serial
    /**
     * The algorithm that was used to sign the certificate.
     */
    val signatureAlgorithm: kotlin.String? = builder.signatureAlgorithm
    /**
     * The status of the certificate.
     *
     * Valid values: `PENDING_VALIDATION` | `ISSUED` | `INACTIVE` | `EXPIRED` | `VALIDATION_TIMED_OUT` | `REVOKED` | `FAILED`
     */
    val status: kotlin.String? = builder.status
    /**
     * The name of the entity that is associated with the public key contained in the certificate.
     */
    val subject: kotlin.String? = builder.subject
    /**
     * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate.
     *
     * The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
     */
    val subjectAlternativeNames: List<String>? = builder.subjectAlternativeNames
    /**
     * The source of the certificate. For certificates that Certificate Manager provides, `Type` is `AMAZON_ISSUED`. For certificates that are imported with `ImportCertificate`, `Type` is `IMPORTED`.
     *
     * Valid values: `IMPORTED` | `AMAZON_ISSUED` | `PRIVATE`
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsCertificateManagerCertificateDetails(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("createdAt=$createdAt,")
        append("domainName=$domainName,")
        append("domainValidationOptions=$domainValidationOptions,")
        append("extendedKeyUsages=$extendedKeyUsages,")
        append("failureReason=$failureReason,")
        append("importedAt=$importedAt,")
        append("inUseBy=$inUseBy,")
        append("issuedAt=$issuedAt,")
        append("issuer=$issuer,")
        append("keyAlgorithm=$keyAlgorithm,")
        append("keyUsages=$keyUsages,")
        append("notAfter=$notAfter,")
        append("notBefore=$notBefore,")
        append("options=$options,")
        append("renewalEligibility=$renewalEligibility,")
        append("renewalSummary=$renewalSummary,")
        append("serial=$serial,")
        append("signatureAlgorithm=$signatureAlgorithm,")
        append("status=$status,")
        append("subject=$subject,")
        append("subjectAlternativeNames=$subjectAlternativeNames,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainValidationOptions?.hashCode() ?: 0)
        result = 31 * result + (extendedKeyUsages?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (importedAt?.hashCode() ?: 0)
        result = 31 * result + (inUseBy?.hashCode() ?: 0)
        result = 31 * result + (issuedAt?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (keyAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyUsages?.hashCode() ?: 0)
        result = 31 * result + (notAfter?.hashCode() ?: 0)
        result = 31 * result + (notBefore?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (renewalEligibility?.hashCode() ?: 0)
        result = 31 * result + (renewalSummary?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (signatureAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectAlternativeNames?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsCertificateManagerCertificateDetails

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (createdAt != other.createdAt) return false
        if (domainName != other.domainName) return false
        if (domainValidationOptions != other.domainValidationOptions) return false
        if (extendedKeyUsages != other.extendedKeyUsages) return false
        if (failureReason != other.failureReason) return false
        if (importedAt != other.importedAt) return false
        if (inUseBy != other.inUseBy) return false
        if (issuedAt != other.issuedAt) return false
        if (issuer != other.issuer) return false
        if (keyAlgorithm != other.keyAlgorithm) return false
        if (keyUsages != other.keyUsages) return false
        if (notAfter != other.notAfter) return false
        if (notBefore != other.notBefore) return false
        if (options != other.options) return false
        if (renewalEligibility != other.renewalEligibility) return false
        if (renewalSummary != other.renewalSummary) return false
        if (serial != other.serial) return false
        if (signatureAlgorithm != other.signatureAlgorithm) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (subjectAlternativeNames != other.subjectAlternativeNames) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the private certificate authority (CA) that will be used to issue the certificate.
         */
        var certificateAuthorityArn: kotlin.String? = null
        /**
         * Indicates when the certificate was requested.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdAt: kotlin.String? = null
        /**
         * The fully qualified domain name (FQDN), such as www.example.com, that is secured by the certificate.
         */
        var domainName: kotlin.String? = null
        /**
         * Contains information about the initial validation of each domain name that occurs as a result of the `RequestCertificate` request.
         *
         * Only provided if the certificate type is `AMAZON_ISSUED`.
         */
        var domainValidationOptions: List<AwsCertificateManagerCertificateDomainValidationOption>? = null
        /**
         * Contains a list of Extended Key Usage X.509 v3 extension objects. Each object specifies a purpose for which the certificate public key can be used and consists of a name and an object identifier (OID).
         */
        var extendedKeyUsages: List<AwsCertificateManagerCertificateExtendedKeyUsage>? = null
        /**
         * For a failed certificate request, the reason for the failure.
         *
         * Valid values: `NO_AVAILABLE_CONTACTS` | `ADDITIONAL_VERIFICATION_REQUIRED` | `DOMAIN_NOT_ALLOWED` | `INVALID_PUBLIC_DOMAIN` | `DOMAIN_VALIDATION_DENIED` | `CAA_ERROR` | `PCA_LIMIT_EXCEEDED` | `PCA_INVALID_ARN` | `PCA_INVALID_STATE` | `PCA_REQUEST_FAILED` | `PCA_NAME_CONSTRAINTS_VALIDATION` | `PCA_RESOURCE_NOT_FOUND` | `PCA_INVALID_ARGS` | `PCA_INVALID_DURATION` | `PCA_ACCESS_DENIED` | `SLR_NOT_FOUND` | `OTHER`
         */
        var failureReason: kotlin.String? = null
        /**
         * Indicates when the certificate was imported. Provided if the certificate type is `IMPORTED`.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var importedAt: kotlin.String? = null
        /**
         * The list of ARNs for the Amazon Web Services resources that use the certificate.
         */
        var inUseBy: List<String>? = null
        /**
         * Indicates when the certificate was issued. Provided if the certificate type is `AMAZON_ISSUED`.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var issuedAt: kotlin.String? = null
        /**
         * The name of the certificate authority that issued and signed the certificate.
         */
        var issuer: kotlin.String? = null
        /**
         * The algorithm that was used to generate the public-private key pair.
         *
         * Valid values: `RSA_2048` | `RSA_1024` |` RSA_4096` | `EC_prime256v1` | `EC_secp384r1` | `EC_secp521r1`
         */
        var keyAlgorithm: kotlin.String? = null
        /**
         * A list of key usage X.509 v3 extension objects.
         */
        var keyUsages: List<AwsCertificateManagerCertificateKeyUsage>? = null
        /**
         * The time after which the certificate becomes invalid.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var notAfter: kotlin.String? = null
        /**
         * The time before which the certificate is not valid.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var notBefore: kotlin.String? = null
        /**
         * Provides a value that specifies whether to add the certificate to a transparency log.
         */
        var options: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateOptions? = null
        /**
         * Whether the certificate is eligible for renewal.
         *
         * Valid values: `ELIGIBLE` | `INELIGIBLE`
         */
        var renewalEligibility: kotlin.String? = null
        /**
         * Information about the status of the Certificate Manager managed renewal for the certificate. Provided only when the certificate type is `AMAZON_ISSUED`.
         */
        var renewalSummary: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary? = null
        /**
         * The serial number of the certificate.
         */
        var serial: kotlin.String? = null
        /**
         * The algorithm that was used to sign the certificate.
         */
        var signatureAlgorithm: kotlin.String? = null
        /**
         * The status of the certificate.
         *
         * Valid values: `PENDING_VALIDATION` | `ISSUED` | `INACTIVE` | `EXPIRED` | `VALIDATION_TIMED_OUT` | `REVOKED` | `FAILED`
         */
        var status: kotlin.String? = null
        /**
         * The name of the entity that is associated with the public key contained in the certificate.
         */
        var subject: kotlin.String? = null
        /**
         * One or more domain names (subject alternative names) included in the certificate. This list contains the domain names that are bound to the public key that is contained in the certificate.
         *
         * The subject alternative names include the canonical domain name (CN) of the certificate and additional domain names that can be used to connect to the website.
         */
        var subjectAlternativeNames: List<String>? = null
        /**
         * The source of the certificate. For certificates that Certificate Manager provides, `Type` is `AMAZON_ISSUED`. For certificates that are imported with `ImportCertificate`, `Type` is `IMPORTED`.
         *
         * Valid values: `IMPORTED` | `AMAZON_ISSUED` | `PRIVATE`
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.createdAt = x.createdAt
            this.domainName = x.domainName
            this.domainValidationOptions = x.domainValidationOptions
            this.extendedKeyUsages = x.extendedKeyUsages
            this.failureReason = x.failureReason
            this.importedAt = x.importedAt
            this.inUseBy = x.inUseBy
            this.issuedAt = x.issuedAt
            this.issuer = x.issuer
            this.keyAlgorithm = x.keyAlgorithm
            this.keyUsages = x.keyUsages
            this.notAfter = x.notAfter
            this.notBefore = x.notBefore
            this.options = x.options
            this.renewalEligibility = x.renewalEligibility
            this.renewalSummary = x.renewalSummary
            this.serial = x.serial
            this.signatureAlgorithm = x.signatureAlgorithm
            this.status = x.status
            this.subject = x.subject
            this.subjectAlternativeNames = x.subjectAlternativeNames
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails = AwsCertificateManagerCertificateDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateOptions] inside the given [block]
         */
        fun options(block: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary] inside the given [block]
         */
        fun renewalSummary(block: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.Builder.() -> kotlin.Unit) {
            this.renewalSummary = aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.invoke(block)
        }
    }
}
