// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about a launch configuration.
 */
class AwsAutoScalingLaunchConfigurationDetails private constructor(builder: Builder) {
    /**
     * For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's instances.
     */
    val associatePublicIpAddress: kotlin.Boolean = builder.associatePublicIpAddress
    /**
     * Specifies the block devices for the instance.
     */
    val blockDeviceMappings: List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>? = builder.blockDeviceMappings
    /**
     * The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
     */
    val classicLinkVpcId: kotlin.String? = builder.classicLinkVpcId
    /**
     * The identifiers of one or more security groups for the VPC that is specified in `ClassicLinkVPCId`.
     */
    val classicLinkVpcSecurityGroups: List<String>? = builder.classicLinkVpcSecurityGroups
    /**
     * The creation date and time for the launch configuration.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdTime: kotlin.String? = builder.createdTime
    /**
     * Whether the launch configuration is optimized for Amazon EBS I/O.
     */
    val ebsOptimized: kotlin.Boolean = builder.ebsOptimized
    /**
     * The name or the ARN of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.
     */
    val iamInstanceProfile: kotlin.String? = builder.iamInstanceProfile
    /**
     * The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * Indicates the type of monitoring for instances in the group.
     */
    val instanceMonitoring: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails? = builder.instanceMonitoring
    /**
     * The instance type for the instances.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The identifier of the kernel associated with the AMI.
     */
    val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: kotlin.String? = builder.keyName
    /**
     * The name of the launch configuration.
     */
    val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The metadata options for the instances.
     */
    val metadataOptions: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions? = builder.metadataOptions
    /**
     * The tenancy of the instance. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
     */
    val placementTenancy: kotlin.String? = builder.placementTenancy
    /**
     * The identifier of the RAM disk associated with the AMI.
     */
    val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * The security groups to assign to the instances in the Auto Scaling group.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
     */
    val spotPrice: kotlin.String? = builder.spotPrice
    /**
     * The user data to make available to the launched EC2 instances. Must be base64-encoded text.
     */
    val userData: kotlin.String? = builder.userData

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAutoScalingLaunchConfigurationDetails(")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("classicLinkVpcId=$classicLinkVpcId,")
        append("classicLinkVpcSecurityGroups=$classicLinkVpcSecurityGroups,")
        append("createdTime=$createdTime,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceMonitoring=$instanceMonitoring,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("metadataOptions=$metadataOptions,")
        append("placementTenancy=$placementTenancy,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroups=$securityGroups,")
        append("spotPrice=$spotPrice,")
        append("userData=$userData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatePublicIpAddress.hashCode()
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcId?.hashCode() ?: 0)
        result = 31 * result + (classicLinkVpcSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized.hashCode())
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceMonitoring?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (placementTenancy?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAutoScalingLaunchConfigurationDetails

        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (classicLinkVpcId != other.classicLinkVpcId) return false
        if (classicLinkVpcSecurityGroups != other.classicLinkVpcSecurityGroups) return false
        if (createdTime != other.createdTime) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceMonitoring != other.instanceMonitoring) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (metadataOptions != other.metadataOptions) return false
        if (placementTenancy != other.placementTenancy) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroups != other.securityGroups) return false
        if (spotPrice != other.spotPrice) return false
        if (userData != other.userData) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * For Auto Scaling groups that run in a VPC, specifies whether to assign a public IP address to the group's instances.
         */
        var associatePublicIpAddress: kotlin.Boolean = false
        /**
         * Specifies the block devices for the instance.
         */
        var blockDeviceMappings: List<AwsAutoScalingLaunchConfigurationBlockDeviceMappingsDetails>? = null
        /**
         * The identifier of a ClassicLink-enabled VPC that EC2-Classic instances are linked to.
         */
        var classicLinkVpcId: kotlin.String? = null
        /**
         * The identifiers of one or more security groups for the VPC that is specified in `ClassicLinkVPCId`.
         */
        var classicLinkVpcSecurityGroups: List<String>? = null
        /**
         * The creation date and time for the launch configuration.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdTime: kotlin.String? = null
        /**
         * Whether the launch configuration is optimized for Amazon EBS I/O.
         */
        var ebsOptimized: kotlin.Boolean = false
        /**
         * The name or the ARN of the instance profile associated with the IAM role for the instance. The instance profile contains the IAM role.
         */
        var iamInstanceProfile: kotlin.String? = null
        /**
         * The identifier of the Amazon Machine Image (AMI) that is used to launch EC2 instances.
         */
        var imageId: kotlin.String? = null
        /**
         * Indicates the type of monitoring for instances in the group.
         */
        var instanceMonitoring: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails? = null
        /**
         * The instance type for the instances.
         */
        var instanceType: kotlin.String? = null
        /**
         * The identifier of the kernel associated with the AMI.
         */
        var kernelId: kotlin.String? = null
        /**
         * The name of the key pair.
         */
        var keyName: kotlin.String? = null
        /**
         * The name of the launch configuration.
         */
        var launchConfigurationName: kotlin.String? = null
        /**
         * The metadata options for the instances.
         */
        var metadataOptions: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions? = null
        /**
         * The tenancy of the instance. An instance with `dedicated` tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC.
         */
        var placementTenancy: kotlin.String? = null
        /**
         * The identifier of the RAM disk associated with the AMI.
         */
        var ramdiskId: kotlin.String? = null
        /**
         * The security groups to assign to the instances in the Auto Scaling group.
         */
        var securityGroups: List<String>? = null
        /**
         * The maximum hourly price to be paid for any Spot Instance that is launched to fulfill the request.
         */
        var spotPrice: kotlin.String? = null
        /**
         * The user data to make available to the launched EC2 instances. Must be base64-encoded text.
         */
        var userData: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails) : this() {
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.blockDeviceMappings = x.blockDeviceMappings
            this.classicLinkVpcId = x.classicLinkVpcId
            this.classicLinkVpcSecurityGroups = x.classicLinkVpcSecurityGroups
            this.createdTime = x.createdTime
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceMonitoring = x.instanceMonitoring
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchConfigurationName = x.launchConfigurationName
            this.metadataOptions = x.metadataOptions
            this.placementTenancy = x.placementTenancy
            this.ramdiskId = x.ramdiskId
            this.securityGroups = x.securityGroups
            this.spotPrice = x.spotPrice
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails = AwsAutoScalingLaunchConfigurationDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails] inside the given [block]
         */
        fun instanceMonitoring(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.Builder.() -> kotlin.Unit) {
            this.instanceMonitoring = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationInstanceMonitoringDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions] inside the given [block]
         */
        fun metadataOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.invoke(block)
        }
    }
}
