// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Parameters that are used to automatically set up EBS volumes when an instance is launched.
 */
class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails private constructor(builder: Builder) {
    /**
     * Whether to delete the volume when the instance is terminated.
     */
    val deleteOnTermination: kotlin.Boolean = builder.deleteOnTermination
    /**
     * Whether to encrypt the volume.
     */
    val encrypted: kotlin.Boolean = builder.encrypted
    /**
     * The number of input/output (I/O) operations per second (IOPS) to provision for the volume.
     *
     * Only supported for `gp3` or `io1` volumes. Required for `io1` volumes. Not used with `standard`, `gp2`, `st1`, or `sc1` volumes.
     */
    val iops: kotlin.Int = builder.iops
    /**
     * The snapshot ID of the volume to use.
     *
     * You must specify either `VolumeSize` or `SnapshotId`.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
     * + gp2 and gp3: 1-16,384
     * + io1: 4-16,384
     * + st1 and sc1: 125-16,384
     * + standard: 1-1,024
     *
     * You must specify either `SnapshotId` or `VolumeSize`. If you specify both `SnapshotId` and `VolumeSize`, the volume size must be equal or greater than the size of the snapshot.
     */
    val volumeSize: kotlin.Int = builder.volumeSize
    /**
     * The volume type.
     */
    val volumeType: kotlin.String? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("snapshotId=$snapshotId,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination.hashCode()
        result = 31 * result + (encrypted.hashCode())
        result = 31 * result + (iops)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (snapshotId != other.snapshotId) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Whether to delete the volume when the instance is terminated.
         */
        var deleteOnTermination: kotlin.Boolean = false
        /**
         * Whether to encrypt the volume.
         */
        var encrypted: kotlin.Boolean = false
        /**
         * The number of input/output (I/O) operations per second (IOPS) to provision for the volume.
         *
         * Only supported for `gp3` or `io1` volumes. Required for `io1` volumes. Not used with `standard`, `gp2`, `st1`, or `sc1` volumes.
         */
        var iops: kotlin.Int = 0
        /**
         * The snapshot ID of the volume to use.
         *
         * You must specify either `VolumeSize` or `SnapshotId`.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The volume size, in GiBs. The following are the supported volumes sizes for each volume type:
         * + gp2 and gp3: 1-16,384
         * + io1: 4-16,384
         * + st1 and sc1: 125-16,384
         * + standard: 1-1,024
         *
         * You must specify either `SnapshotId` or `VolumeSize`. If you specify both `SnapshotId` and `VolumeSize`, the volume size must be equal or greater than the size of the snapshot.
         */
        var volumeSize: kotlin.Int = 0
        /**
         * The volume type.
         */
        var volumeType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.snapshotId = x.snapshotId
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails = AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(this)
    }
}
