// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an auto scaling group.
 */
class AwsAutoScalingAutoScalingGroupDetails private constructor(builder: Builder) {
    /**
     * The list of Availability Zones for the automatic scaling group.
     */
    val availabilityZones: List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>? = builder.availabilityZones
    /**
     * Indicates whether capacity rebalancing is enabled.
     */
    val capacityRebalance: kotlin.Boolean = builder.capacityRebalance
    /**
     * Indicates when the auto scaling group was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdTime: kotlin.String? = builder.createdTime
    /**
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.
     */
    val healthCheckGracePeriod: kotlin.Int = builder.healthCheckGracePeriod
    /**
     * The service to use for the health checks.
     */
    val healthCheckType: kotlin.String? = builder.healthCheckType
    /**
     * The name of the launch configuration.
     */
    val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The launch template to use.
     */
    val launchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The list of load balancers associated with the group.
     */
    val loadBalancerNames: List<String>? = builder.loadBalancerNames
    /**
     * The mixed instances policy for the automatic scaling group.
     */
    val mixedInstancesPolicy: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails? = builder.mixedInstancesPolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAutoScalingAutoScalingGroupDetails(")
        append("availabilityZones=$availabilityZones,")
        append("capacityRebalance=$capacityRebalance,")
        append("createdTime=$createdTime,")
        append("healthCheckGracePeriod=$healthCheckGracePeriod,")
        append("healthCheckType=$healthCheckType,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("loadBalancerNames=$loadBalancerNames,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (capacityRebalance.hashCode())
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriod)
        result = 31 * result + (healthCheckType?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerNames?.hashCode() ?: 0)
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAutoScalingAutoScalingGroupDetails

        if (availabilityZones != other.availabilityZones) return false
        if (capacityRebalance != other.capacityRebalance) return false
        if (createdTime != other.createdTime) return false
        if (healthCheckGracePeriod != other.healthCheckGracePeriod) return false
        if (healthCheckType != other.healthCheckType) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (loadBalancerNames != other.loadBalancerNames) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of Availability Zones for the automatic scaling group.
         */
        var availabilityZones: List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>? = null
        /**
         * Indicates whether capacity rebalancing is enabled.
         */
        var capacityRebalance: kotlin.Boolean = false
        /**
         * Indicates when the auto scaling group was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdTime: kotlin.String? = null
        /**
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.
         */
        var healthCheckGracePeriod: kotlin.Int = 0
        /**
         * The service to use for the health checks.
         */
        var healthCheckType: kotlin.String? = null
        /**
         * The name of the launch configuration.
         */
        var launchConfigurationName: kotlin.String? = null
        /**
         * The launch template to use.
         */
        var launchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification? = null
        /**
         * The list of load balancers associated with the group.
         */
        var loadBalancerNames: List<String>? = null
        /**
         * The mixed instances policy for the automatic scaling group.
         */
        var mixedInstancesPolicy: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails) : this() {
            this.availabilityZones = x.availabilityZones
            this.capacityRebalance = x.capacityRebalance
            this.createdTime = x.createdTime
            this.healthCheckGracePeriod = x.healthCheckGracePeriod
            this.healthCheckType = x.healthCheckType
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.loadBalancerNames = x.loadBalancerNames
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = AwsAutoScalingAutoScalingGroupDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification] inside the given [block]
         */
        fun launchTemplate(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails] inside the given [block]
         */
        fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.invoke(block)
        }
    }
}
