// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about a version 2 stage for Amazon API Gateway.
 */
class AwsApiGatewayV2StageDetails private constructor(builder: Builder) {
    /**
     * Information about settings for logging access for the stage.
     */
    val accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = builder.accessLogSettings
    /**
     * Indicates whether the stage is managed by API Gateway.
     */
    val apiGatewayManaged: kotlin.Boolean = builder.apiGatewayManaged
    /**
     * Indicates whether updates to an API automatically trigger a new deployment.
     */
    val autoDeploy: kotlin.Boolean = builder.autoDeploy
    /**
     * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
     */
    val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * Indicates when the stage was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val createdDate: kotlin.String? = builder.createdDate
    /**
     * Default route settings for the stage.
     */
    val defaultRouteSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = builder.defaultRouteSettings
    /**
     * The identifier of the deployment that the stage is associated with.
     */
    val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The description of the stage.
     */
    val description: kotlin.String? = builder.description
    /**
     * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
     */
    val lastDeploymentStatusMessage: kotlin.String? = builder.lastDeploymentStatusMessage
    /**
     * Indicates when the stage was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     */
    val lastUpdatedDate: kotlin.String? = builder.lastUpdatedDate
    /**
     * The route settings for the stage.
     */
    val routeSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = builder.routeSettings
    /**
     * The name of the stage.
     */
    val stageName: kotlin.String? = builder.stageName
    /**
     * A map that defines the stage variables for the stage.
     *
     * Variable names can have alphanumeric and underscore characters.
     *
     * Variable values can contain the following characters:
     * + Uppercase and lowercase letters
     * + Numbers
     * + Special characters -._~:/?#&=,
     */
    val stageVariables: Map<String, String>? = builder.stageVariables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayV2StageDetails(")
        append("accessLogSettings=$accessLogSettings,")
        append("apiGatewayManaged=$apiGatewayManaged,")
        append("autoDeploy=$autoDeploy,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("defaultRouteSettings=$defaultRouteSettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("lastDeploymentStatusMessage=$lastDeploymentStatusMessage,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("routeSettings=$routeSettings,")
        append("stageName=$stageName,")
        append("stageVariables=$stageVariables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (apiGatewayManaged.hashCode())
        result = 31 * result + (autoDeploy.hashCode())
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteSettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (routeSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayV2StageDetails

        if (accessLogSettings != other.accessLogSettings) return false
        if (apiGatewayManaged != other.apiGatewayManaged) return false
        if (autoDeploy != other.autoDeploy) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (defaultRouteSettings != other.defaultRouteSettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (lastDeploymentStatusMessage != other.lastDeploymentStatusMessage) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (routeSettings != other.routeSettings) return false
        if (stageName != other.stageName) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about settings for logging access for the stage.
         */
        var accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = null
        /**
         * Indicates whether the stage is managed by API Gateway.
         */
        var apiGatewayManaged: kotlin.Boolean = false
        /**
         * Indicates whether updates to an API automatically trigger a new deployment.
         */
        var autoDeploy: kotlin.Boolean = false
        /**
         * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
         */
        var clientCertificateId: kotlin.String? = null
        /**
         * Indicates when the stage was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var createdDate: kotlin.String? = null
        /**
         * Default route settings for the stage.
         */
        var defaultRouteSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = null
        /**
         * The identifier of the deployment that the stage is associated with.
         */
        var deploymentId: kotlin.String? = null
        /**
         * The description of the stage.
         */
        var description: kotlin.String? = null
        /**
         * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
         */
        var lastDeploymentStatusMessage: kotlin.String? = null
        /**
         * Indicates when the stage was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         */
        var lastUpdatedDate: kotlin.String? = null
        /**
         * The route settings for the stage.
         */
        var routeSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = null
        /**
         * The name of the stage.
         */
        var stageName: kotlin.String? = null
        /**
         * A map that defines the stage variables for the stage.
         *
         * Variable names can have alphanumeric and underscore characters.
         *
         * Variable values can contain the following characters:
         * + Uppercase and lowercase letters
         * + Numbers
         * + Special characters -._~:/?#&=,
         */
        var stageVariables: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.apiGatewayManaged = x.apiGatewayManaged
            this.autoDeploy = x.autoDeploy
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.defaultRouteSettings = x.defaultRouteSettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.lastDeploymentStatusMessage = x.lastDeploymentStatusMessage
            this.lastUpdatedDate = x.lastUpdatedDate
            this.routeSettings = x.routeSettings
            this.stageName = x.stageName
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = AwsApiGatewayV2StageDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings] inside the given [block]
         */
        fun accessLogSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings] inside the given [block]
         */
        fun defaultRouteSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.Builder.() -> kotlin.Unit) {
            this.defaultRouteSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings] inside the given [block]
         */
        fun routeSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.Builder.() -> kotlin.Unit) {
            this.routeSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.invoke(block)
        }
    }
}
