// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Defines settings for a method for the stage.
 */
class AwsApiGatewayMethodSettings private constructor(builder: Builder) {
    /**
     * Indicates whether the cached responses are encrypted.
     */
    val cacheDataEncrypted: kotlin.Boolean = builder.cacheDataEncrypted
    /**
     * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response is cached.
     */
    val cacheTtlInSeconds: kotlin.Int = builder.cacheTtlInSeconds
    /**
     * Indicates whether responses are cached and returned for requests. For responses to be cached, a cache cluster must be enabled on the stage.
     */
    val cachingEnabled: kotlin.Boolean = builder.cachingEnabled
    /**
     * Indicates whether data trace logging is enabled for the method. Data trace logging affects the log entries that are pushed to CloudWatch Logs.
     */
    val dataTraceEnabled: kotlin.Boolean = builder.dataTraceEnabled
    /**
     * The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
     */
    val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * The logging level for this method. The logging level affects the log entries that are pushed to CloudWatch Logs.
     *
     * If the logging level is `ERROR`, then the logs only include error-level entries.
     *
     * If the logging level is `INFO`, then the logs include both `ERROR` events and extra informational events.
     *
     * Valid values: `OFF` | `ERROR` | `INFO`
     */
    val loggingLevel: kotlin.String? = builder.loggingLevel
    /**
     * Indicates whether CloudWatch metrics are enabled for the method.
     */
    val metricsEnabled: kotlin.Boolean = builder.metricsEnabled
    /**
     * Indicates whether authorization is required for a cache invalidation request.
     */
    val requireAuthorizationForCacheControl: kotlin.Boolean = builder.requireAuthorizationForCacheControl
    /**
     * The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include a forward slash.
     *
     * For example, the path value `/resource/subresource` must be encoded as `/~1resource~1subresource`.
     *
     * To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
     */
    val resourcePath: kotlin.String? = builder.resourcePath
    /**
     * The throttling burst limit for the method.
     */
    val throttlingBurstLimit: kotlin.Int = builder.throttlingBurstLimit
    /**
     * The throttling rate limit for the method.
     */
    val throttlingRateLimit: kotlin.Double = builder.throttlingRateLimit
    /**
     * Indicates how to handle unauthorized requests for cache invalidation.
     *
     * Valid values: `FAIL_WITH_403` | `SUCCEED_WITH_RESPONSE_HEADER` | `SUCCEED_WITHOUT_RESPONSE_HEADER`
     */
    val unauthorizedCacheControlHeaderStrategy: kotlin.String? = builder.unauthorizedCacheControlHeaderStrategy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayMethodSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayMethodSettings(")
        append("cacheDataEncrypted=$cacheDataEncrypted,")
        append("cacheTtlInSeconds=$cacheTtlInSeconds,")
        append("cachingEnabled=$cachingEnabled,")
        append("dataTraceEnabled=$dataTraceEnabled,")
        append("httpMethod=$httpMethod,")
        append("loggingLevel=$loggingLevel,")
        append("metricsEnabled=$metricsEnabled,")
        append("requireAuthorizationForCacheControl=$requireAuthorizationForCacheControl,")
        append("resourcePath=$resourcePath,")
        append("throttlingBurstLimit=$throttlingBurstLimit,")
        append("throttlingRateLimit=$throttlingRateLimit,")
        append("unauthorizedCacheControlHeaderStrategy=$unauthorizedCacheControlHeaderStrategy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheDataEncrypted.hashCode()
        result = 31 * result + (cacheTtlInSeconds)
        result = 31 * result + (cachingEnabled.hashCode())
        result = 31 * result + (dataTraceEnabled.hashCode())
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (loggingLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsEnabled.hashCode())
        result = 31 * result + (requireAuthorizationForCacheControl.hashCode())
        result = 31 * result + (resourcePath?.hashCode() ?: 0)
        result = 31 * result + (throttlingBurstLimit)
        result = 31 * result + (throttlingRateLimit.hashCode())
        result = 31 * result + (unauthorizedCacheControlHeaderStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayMethodSettings

        if (cacheDataEncrypted != other.cacheDataEncrypted) return false
        if (cacheTtlInSeconds != other.cacheTtlInSeconds) return false
        if (cachingEnabled != other.cachingEnabled) return false
        if (dataTraceEnabled != other.dataTraceEnabled) return false
        if (httpMethod != other.httpMethod) return false
        if (loggingLevel != other.loggingLevel) return false
        if (metricsEnabled != other.metricsEnabled) return false
        if (requireAuthorizationForCacheControl != other.requireAuthorizationForCacheControl) return false
        if (resourcePath != other.resourcePath) return false
        if (throttlingBurstLimit != other.throttlingBurstLimit) return false
        if (throttlingRateLimit != other.throttlingRateLimit) return false
        if (unauthorizedCacheControlHeaderStrategy != other.unauthorizedCacheControlHeaderStrategy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayMethodSettings = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the cached responses are encrypted.
         */
        var cacheDataEncrypted: kotlin.Boolean = false
        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response is cached.
         */
        var cacheTtlInSeconds: kotlin.Int = 0
        /**
         * Indicates whether responses are cached and returned for requests. For responses to be cached, a cache cluster must be enabled on the stage.
         */
        var cachingEnabled: kotlin.Boolean = false
        /**
         * Indicates whether data trace logging is enabled for the method. Data trace logging affects the log entries that are pushed to CloudWatch Logs.
         */
        var dataTraceEnabled: kotlin.Boolean = false
        /**
         * The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
         */
        var httpMethod: kotlin.String? = null
        /**
         * The logging level for this method. The logging level affects the log entries that are pushed to CloudWatch Logs.
         *
         * If the logging level is `ERROR`, then the logs only include error-level entries.
         *
         * If the logging level is `INFO`, then the logs include both `ERROR` events and extra informational events.
         *
         * Valid values: `OFF` | `ERROR` | `INFO`
         */
        var loggingLevel: kotlin.String? = null
        /**
         * Indicates whether CloudWatch metrics are enabled for the method.
         */
        var metricsEnabled: kotlin.Boolean = false
        /**
         * Indicates whether authorization is required for a cache invalidation request.
         */
        var requireAuthorizationForCacheControl: kotlin.Boolean = false
        /**
         * The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include a forward slash.
         *
         * For example, the path value `/resource/subresource` must be encoded as `/~1resource~1subresource`.
         *
         * To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
         */
        var resourcePath: kotlin.String? = null
        /**
         * The throttling burst limit for the method.
         */
        var throttlingBurstLimit: kotlin.Int = 0
        /**
         * The throttling rate limit for the method.
         */
        var throttlingRateLimit: kotlin.Double = 0.0
        /**
         * Indicates how to handle unauthorized requests for cache invalidation.
         *
         * Valid values: `FAIL_WITH_403` | `SUCCEED_WITH_RESPONSE_HEADER` | `SUCCEED_WITHOUT_RESPONSE_HEADER`
         */
        var unauthorizedCacheControlHeaderStrategy: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayMethodSettings) : this() {
            this.cacheDataEncrypted = x.cacheDataEncrypted
            this.cacheTtlInSeconds = x.cacheTtlInSeconds
            this.cachingEnabled = x.cachingEnabled
            this.dataTraceEnabled = x.dataTraceEnabled
            this.httpMethod = x.httpMethod
            this.loggingLevel = x.loggingLevel
            this.metricsEnabled = x.metricsEnabled
            this.requireAuthorizationForCacheControl = x.requireAuthorizationForCacheControl
            this.resourcePath = x.resourcePath
            this.throttlingBurstLimit = x.throttlingBurstLimit
            this.throttlingRateLimit = x.throttlingRateLimit
            this.unauthorizedCacheControlHeaderStrategy = x.unauthorizedCacheControlHeaderStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayMethodSettings = AwsApiGatewayMethodSettings(this)
    }
}
