// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provided if `ActionType` is `AWS_API_CALL`. It provides details about the API call that was detected.
 */
class AwsApiCallAction private constructor(builder: Builder) {
    /**
     * Identifies the resources that were affected by the API call.
     */
    val affectedResources: Map<String, String>? = builder.affectedResources
    /**
     * The name of the API method that was issued.
     */
    val api: kotlin.String? = builder.api
    /**
     * Indicates whether the API call originated from a remote IP address (`remoteip`) or from a DNS domain (`domain`).
     */
    val callerType: kotlin.String? = builder.callerType
    /**
     * Provided if `CallerType` is `domain`. Provides information about the DNS domain that the API call originated from.
     */
    val domainDetails: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails? = builder.domainDetails
    /**
     * An ISO8601-formatted timestamp that indicates when the API call was first observed.
     */
    val firstSeen: kotlin.String? = builder.firstSeen
    /**
     * An ISO8601-formatted timestamp that indicates when the API call was most recently observed.
     */
    val lastSeen: kotlin.String? = builder.lastSeen
    /**
     * Provided if `CallerType` is `remoteIp`. Provides information about the remote IP address that the API call originated from.
     */
    val remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = builder.remoteIpDetails
    /**
     * The name of the Amazon Web Services service that the API method belongs to.
     */
    val serviceName: kotlin.String? = builder.serviceName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiCallAction(")
        append("affectedResources=$affectedResources,")
        append("api=$api,")
        append("callerType=$callerType,")
        append("domainDetails=$domainDetails,")
        append("firstSeen=$firstSeen,")
        append("lastSeen=$lastSeen,")
        append("remoteIpDetails=$remoteIpDetails,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = affectedResources?.hashCode() ?: 0
        result = 31 * result + (api?.hashCode() ?: 0)
        result = 31 * result + (callerType?.hashCode() ?: 0)
        result = 31 * result + (domainDetails?.hashCode() ?: 0)
        result = 31 * result + (firstSeen?.hashCode() ?: 0)
        result = 31 * result + (lastSeen?.hashCode() ?: 0)
        result = 31 * result + (remoteIpDetails?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiCallAction

        if (affectedResources != other.affectedResources) return false
        if (api != other.api) return false
        if (callerType != other.callerType) return false
        if (domainDetails != other.domainDetails) return false
        if (firstSeen != other.firstSeen) return false
        if (lastSeen != other.lastSeen) return false
        if (remoteIpDetails != other.remoteIpDetails) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Identifies the resources that were affected by the API call.
         */
        var affectedResources: Map<String, String>? = null
        /**
         * The name of the API method that was issued.
         */
        var api: kotlin.String? = null
        /**
         * Indicates whether the API call originated from a remote IP address (`remoteip`) or from a DNS domain (`domain`).
         */
        var callerType: kotlin.String? = null
        /**
         * Provided if `CallerType` is `domain`. Provides information about the DNS domain that the API call originated from.
         */
        var domainDetails: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the API call was first observed.
         */
        var firstSeen: kotlin.String? = null
        /**
         * An ISO8601-formatted timestamp that indicates when the API call was most recently observed.
         */
        var lastSeen: kotlin.String? = null
        /**
         * Provided if `CallerType` is `remoteIp`. Provides information about the remote IP address that the API call originated from.
         */
        var remoteIpDetails: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails? = null
        /**
         * The name of the Amazon Web Services service that the API method belongs to.
         */
        var serviceName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction) : this() {
            this.affectedResources = x.affectedResources
            this.api = x.api
            this.callerType = x.callerType
            this.domainDetails = x.domainDetails
            this.firstSeen = x.firstSeen
            this.lastSeen = x.lastSeen
            this.remoteIpDetails = x.remoteIpDetails
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction = AwsApiCallAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails] inside the given [block]
         */
        fun domainDetails(block: aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails.Builder.() -> kotlin.Unit) {
            this.domainDetails = aws.sdk.kotlin.services.securityhub.model.AwsApiCallActionDomainDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails] inside the given [block]
         */
        fun remoteIpDetails(block: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.Builder.() -> kotlin.Unit) {
            this.remoteIpDetails = aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails.invoke(block)
        }
    }
}
