// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * For `AwsApiAction`, `NetworkConnectionAction`, and `PortProbeAction`, `RemoteIpDetails` provides information about the remote IP address that was involved in the action.
 */
class ActionRemoteIpDetails private constructor(builder: Builder) {
    /**
     * The city where the remote IP address is located.
     */
    val city: aws.sdk.kotlin.services.securityhub.model.City? = builder.city
    /**
     * The country where the remote IP address is located.
     */
    val country: aws.sdk.kotlin.services.securityhub.model.Country? = builder.country
    /**
     * The coordinates of the location of the remote IP address.
     */
    val geoLocation: aws.sdk.kotlin.services.securityhub.model.GeoLocation? = builder.geoLocation
    /**
     * The IP address.
     */
    val ipAddressV4: kotlin.String? = builder.ipAddressV4
    /**
     * The internet service provider (ISP) organization associated with the remote IP address.
     */
    val organization: aws.sdk.kotlin.services.securityhub.model.IpOrganizationDetails? = builder.organization

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ActionRemoteIpDetails(")
        append("city=$city,")
        append("country=$country,")
        append("geoLocation=$geoLocation,")
        append("ipAddressV4=$ipAddressV4,")
        append("organization=$organization)")
    }

    override fun hashCode(): kotlin.Int {
        var result = city?.hashCode() ?: 0
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (geoLocation?.hashCode() ?: 0)
        result = 31 * result + (ipAddressV4?.hashCode() ?: 0)
        result = 31 * result + (organization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ActionRemoteIpDetails

        if (city != other.city) return false
        if (country != other.country) return false
        if (geoLocation != other.geoLocation) return false
        if (ipAddressV4 != other.ipAddressV4) return false
        if (organization != other.organization) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * The city where the remote IP address is located.
         */
        var city: aws.sdk.kotlin.services.securityhub.model.City? = null
        /**
         * The country where the remote IP address is located.
         */
        var country: aws.sdk.kotlin.services.securityhub.model.Country? = null
        /**
         * The coordinates of the location of the remote IP address.
         */
        var geoLocation: aws.sdk.kotlin.services.securityhub.model.GeoLocation? = null
        /**
         * The IP address.
         */
        var ipAddressV4: kotlin.String? = null
        /**
         * The internet service provider (ISP) organization associated with the remote IP address.
         */
        var organization: aws.sdk.kotlin.services.securityhub.model.IpOrganizationDetails? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails) : this() {
            this.city = x.city
            this.country = x.country
            this.geoLocation = x.geoLocation
            this.ipAddressV4 = x.ipAddressV4
            this.organization = x.organization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ActionRemoteIpDetails = ActionRemoteIpDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.City] inside the given [block]
         */
        fun city(block: aws.sdk.kotlin.services.securityhub.model.City.Builder.() -> kotlin.Unit) {
            this.city = aws.sdk.kotlin.services.securityhub.model.City.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.Country] inside the given [block]
         */
        fun country(block: aws.sdk.kotlin.services.securityhub.model.Country.Builder.() -> kotlin.Unit) {
            this.country = aws.sdk.kotlin.services.securityhub.model.Country.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.GeoLocation] inside the given [block]
         */
        fun geoLocation(block: aws.sdk.kotlin.services.securityhub.model.GeoLocation.Builder.() -> kotlin.Unit) {
            this.geoLocation = aws.sdk.kotlin.services.securityhub.model.GeoLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.IpOrganizationDetails] inside the given [block]
         */
        fun organization(block: aws.sdk.kotlin.services.securityhub.model.IpOrganizationDetails.Builder.() -> kotlin.Unit) {
            this.organization = aws.sdk.kotlin.services.securityhub.model.IpOrganizationDetails.invoke(block)
        }
    }
}
