// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about one of the following actions that affects or that was taken on a resource:
 * + A remote IP address issued an Amazon Web Services API call
 * + A DNS request was received
 * + A remote IP address attempted to connect to an EC2 instance
 * + A remote IP address attempted a port probe on an EC2 instance
 */
class Action private constructor(builder: Builder) {
    /**
     * The type of action that was detected. The possible action types are:
     * + `NETWORK_CONNECTION`
     * + `AWS_API_CALL`
     * + `DNS_REQUEST`
     * + `PORT_PROBE`
     */
    val actionType: kotlin.String? = builder.actionType
    /**
     * Included if `ActionType` is `AWS_API_CALL`. Provides details about the API call that was detected.
     */
    val awsApiCallAction: aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction? = builder.awsApiCallAction
    /**
     * Included if `ActionType` is `DNS_REQUEST`. Provides details about the DNS request that was detected.
     */
    val dnsRequestAction: aws.sdk.kotlin.services.securityhub.model.DnsRequestAction? = builder.dnsRequestAction
    /**
     * Included if `ActionType` is `NETWORK_CONNECTION`. Provides details about the network connection that was detected.
     */
    val networkConnectionAction: aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction? = builder.networkConnectionAction
    /**
     * Included if `ActionType` is `PORT_PROBE`. Provides details about the port probe that was detected.
     */
    val portProbeAction: aws.sdk.kotlin.services.securityhub.model.PortProbeAction? = builder.portProbeAction

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("actionType=$actionType,")
        append("awsApiCallAction=$awsApiCallAction,")
        append("dnsRequestAction=$dnsRequestAction,")
        append("networkConnectionAction=$networkConnectionAction,")
        append("portProbeAction=$portProbeAction)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionType?.hashCode() ?: 0
        result = 31 * result + (awsApiCallAction?.hashCode() ?: 0)
        result = 31 * result + (dnsRequestAction?.hashCode() ?: 0)
        result = 31 * result + (networkConnectionAction?.hashCode() ?: 0)
        result = 31 * result + (portProbeAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (actionType != other.actionType) return false
        if (awsApiCallAction != other.awsApiCallAction) return false
        if (dnsRequestAction != other.dnsRequestAction) return false
        if (networkConnectionAction != other.networkConnectionAction) return false
        if (portProbeAction != other.portProbeAction) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Action = Builder(this).apply(block).build()

    class Builder {
        /**
         * The type of action that was detected. The possible action types are:
         * + `NETWORK_CONNECTION`
         * + `AWS_API_CALL`
         * + `DNS_REQUEST`
         * + `PORT_PROBE`
         */
        var actionType: kotlin.String? = null
        /**
         * Included if `ActionType` is `AWS_API_CALL`. Provides details about the API call that was detected.
         */
        var awsApiCallAction: aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction? = null
        /**
         * Included if `ActionType` is `DNS_REQUEST`. Provides details about the DNS request that was detected.
         */
        var dnsRequestAction: aws.sdk.kotlin.services.securityhub.model.DnsRequestAction? = null
        /**
         * Included if `ActionType` is `NETWORK_CONNECTION`. Provides details about the network connection that was detected.
         */
        var networkConnectionAction: aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction? = null
        /**
         * Included if `ActionType` is `PORT_PROBE`. Provides details about the port probe that was detected.
         */
        var portProbeAction: aws.sdk.kotlin.services.securityhub.model.PortProbeAction? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Action) : this() {
            this.actionType = x.actionType
            this.awsApiCallAction = x.awsApiCallAction
            this.dnsRequestAction = x.dnsRequestAction
            this.networkConnectionAction = x.networkConnectionAction
            this.portProbeAction = x.portProbeAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Action = Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction] inside the given [block]
         */
        fun awsApiCallAction(block: aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction.Builder.() -> kotlin.Unit) {
            this.awsApiCallAction = aws.sdk.kotlin.services.securityhub.model.AwsApiCallAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.DnsRequestAction] inside the given [block]
         */
        fun dnsRequestAction(block: aws.sdk.kotlin.services.securityhub.model.DnsRequestAction.Builder.() -> kotlin.Unit) {
            this.dnsRequestAction = aws.sdk.kotlin.services.securityhub.model.DnsRequestAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction] inside the given [block]
         */
        fun networkConnectionAction(block: aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction.Builder.() -> kotlin.Unit) {
            this.networkConnectionAction = aws.sdk.kotlin.services.securityhub.model.NetworkConnectionAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.PortProbeAction] inside the given [block]
         */
        fun portProbeAction(block: aws.sdk.kotlin.services.securityhub.model.PortProbeAction.Builder.() -> kotlin.Unit) {
            this.portProbeAction = aws.sdk.kotlin.services.securityhub.model.PortProbeAction.invoke(block)
        }
    }
}
