// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.securityhub.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.securityhub.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Security Hub provides you with a comprehensive view of the security state of your Amazon Web Services environment and resources. It also provides you with the readiness status of your environment based on controls from supported security standards. Security Hub collects security data from Amazon Web Services accounts, services, and integrated third-party products and helps you analyze security trends in your environment to identify the highest priority security issues. For more information about Security Hub, see the *Security HubUser Guide*[](https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html).
 *
 * When you use operations in the Security Hub API, the requests are executed only in the Amazon Web Services Region that is currently active or in the specific Amazon Web Services Region that you specify in your request. Any configuration or settings change that results from the operation is applied only to that Region. To make the same change in other Regions, execute the same command for each Region to apply the change to.
 *
 * For example, if your Region is set to `us-west-2`, when you use `CreateMembers` to add a member account to Security Hub, the association of the member account with the administrator account is created only in the `us-west-2` Region. Security Hub must be enabled for the member account in the same Region that the invitation was sent from.
 *
 * The following throttling limits apply to using Security Hub API operations.
 * + `BatchEnableStandards` - `RateLimit` of 1 request per second, `BurstLimit` of 1 request per second.
 * + `GetFindings` - `RateLimit` of 3 requests per second. `BurstLimit` of 6 requests per second.
 * + `BatchImportFindings` - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 * + `BatchUpdateFindings` - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 * + `UpdateStandardsControl` - `RateLimit` of 1 request per second, `BurstLimit` of 5 requests per second.
 * + All other operations - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 */
interface SecurityHubClient : SdkClient {

    override val serviceName: String
        get() = "SecurityHub"
    /**
     * SecurityHubClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): SecurityHubClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSecurityHubClient(config)
        }

        operator fun invoke(config: Config): SecurityHubClient = DefaultSecurityHubClient(config)

        /**
         * Construct a [SecurityHubClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SecurityHubClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultSecurityHubClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    suspend fun acceptAdministratorInvitation(input: AcceptAdministratorInvitationRequest): AcceptAdministratorInvitationResponse

    /**
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    suspend fun acceptAdministratorInvitation(block: AcceptAdministratorInvitationRequest.Builder.() -> Unit) = acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.Builder().apply(block).build())

    /**
     * This method is deprecated. Instead, use `AcceptAdministratorInvitation`.
     *
     * The Security Hub console continues to use `AcceptInvitation`. It will eventually change to use `AcceptAdministratorInvitation`. Any IAM policies that specifically control access to this function must continue to use `AcceptInvitation`. You should also add `AcceptAdministratorInvitation` to your policies to ensure that the correct permissions are in place after the console begins to use `AcceptAdministratorInvitation`.
     *
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * This method is deprecated. Instead, use `AcceptAdministratorInvitation`.
     *
     * The Security Hub console continues to use `AcceptInvitation`. It will eventually change to use `AcceptAdministratorInvitation`. Any IAM policies that specifically control access to this function must continue to use `AcceptInvitation`. You should also add `AcceptAdministratorInvitation` to your policies to ensure that the correct permissions are in place after the console begins to use `AcceptAdministratorInvitation`.
     *
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun acceptInvitation(block: AcceptInvitationRequest.Builder.() -> Unit) = acceptInvitation(AcceptInvitationRequest.Builder().apply(block).build())

    /**
     * Disables the standards specified by the provided `StandardsSubscriptionArns`.
     *
     * For more information, see [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    suspend fun batchDisableStandards(input: BatchDisableStandardsRequest): BatchDisableStandardsResponse

    /**
     * Disables the standards specified by the provided `StandardsSubscriptionArns`.
     *
     * For more information, see [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    suspend fun batchDisableStandards(block: BatchDisableStandardsRequest.Builder.() -> Unit) = batchDisableStandards(BatchDisableStandardsRequest.Builder().apply(block).build())

    /**
     * Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the `DescribeStandards` operation.
     *
     * For more information, see the [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    suspend fun batchEnableStandards(input: BatchEnableStandardsRequest): BatchEnableStandardsResponse

    /**
     * Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the `DescribeStandards` operation.
     *
     * For more information, see the [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    suspend fun batchEnableStandards(block: BatchEnableStandardsRequest.Builder.() -> Unit) = batchEnableStandards(BatchEnableStandardsRequest.Builder().apply(block).build())

    /**
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
     *
     * `BatchImportFindings` must be called by one of the following:
     * + The Amazon Web Services account that is associated with a finding if you are using the [default product ARN](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs) or are a partner sending findings from within a customer's Amazon Web Services account. In these cases, the identifier of the account that you are calling `BatchImportFindings` from needs to be the same as the `AwsAccountId` attribute for the finding.
     * + An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call `BatchImportFindings` from the allow-listed account and send findings from different customer accounts in the same batch.
     *
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     *
     * After a finding is created, `BatchImportFindings` cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.
     * + `Note`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * Finding providers also should not use `BatchImportFindings` to update the following attributes.
     * + `Confidence`
     * + `Criticality`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     *
     * Instead, finding providers use `FindingProviderFields` to provide values for these attributes.
     */
    suspend fun batchImportFindings(input: BatchImportFindingsRequest): BatchImportFindingsResponse

    /**
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
     *
     * `BatchImportFindings` must be called by one of the following:
     * + The Amazon Web Services account that is associated with a finding if you are using the [default product ARN](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs) or are a partner sending findings from within a customer's Amazon Web Services account. In these cases, the identifier of the account that you are calling `BatchImportFindings` from needs to be the same as the `AwsAccountId` attribute for the finding.
     * + An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call `BatchImportFindings` from the allow-listed account and send findings from different customer accounts in the same batch.
     *
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     *
     * After a finding is created, `BatchImportFindings` cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.
     * + `Note`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * Finding providers also should not use `BatchImportFindings` to update the following attributes.
     * + `Confidence`
     * + `Criticality`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     *
     * Instead, finding providers use `FindingProviderFields` to provide values for these attributes.
     */
    suspend fun batchImportFindings(block: BatchImportFindingsRequest.Builder.() -> Unit) = batchImportFindings(BatchImportFindingsRequest.Builder().apply(block).build())

    /**
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
     *
     * Updates from `BatchUpdateFindings` do not affect the value of `UpdatedAt` for a finding.
     *
     * Administrator and member accounts can use `BatchUpdateFindings` to update the following finding fields and objects.
     * + `Confidence`
     * + `Criticality`
     * + `Note`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See [Configuring access to BatchUpdateFindings](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access) in the *Security Hub User Guide*.
     */
    suspend fun batchUpdateFindings(input: BatchUpdateFindingsRequest): BatchUpdateFindingsResponse

    /**
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
     *
     * Updates from `BatchUpdateFindings` do not affect the value of `UpdatedAt` for a finding.
     *
     * Administrator and member accounts can use `BatchUpdateFindings` to update the following finding fields and objects.
     * + `Confidence`
     * + `Criticality`
     * + `Note`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See [Configuring access to BatchUpdateFindings](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access) in the *Security Hub User Guide*.
     */
    suspend fun batchUpdateFindings(block: BatchUpdateFindingsRequest.Builder.() -> Unit) = batchUpdateFindings(BatchUpdateFindingsRequest.Builder().apply(block).build())

    /**
     * Creates a custom action target in Security Hub.
     *
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.
     */
    suspend fun createActionTarget(input: CreateActionTargetRequest): CreateActionTargetResponse

    /**
     * Creates a custom action target in Security Hub.
     *
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.
     */
    suspend fun createActionTarget(block: CreateActionTargetRequest.Builder.() -> Unit) = createActionTarget(CreateActionTargetRequest.Builder().apply(block).build())

    /**
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     *
     * For more details about cross-Region replication, see [Configuring finding aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *Security Hub User Guide*.
     */
    suspend fun createFindingAggregator(input: CreateFindingAggregatorRequest): CreateFindingAggregatorResponse

    /**
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     *
     * For more details about cross-Region replication, see [Configuring finding aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *Security Hub User Guide*.
     */
    suspend fun createFindingAggregator(block: CreateFindingAggregatorRequest.Builder.() -> Unit) = createFindingAggregator(CreateFindingAggregatorRequest.Builder().apply(block).build())

    /**
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
     *
     * To group the related findings in the insight, use the `GroupByAttribute`.
     */
    suspend fun createInsight(input: CreateInsightRequest): CreateInsightResponse

    /**
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
     *
     * To group the related findings in the insight, use the `GroupByAttribute`.
     */
    suspend fun createInsight(block: CreateInsightRequest.Builder.() -> Unit) = createInsight(CreateInsightRequest.Builder().apply(block).build())

    /**
     * Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
     *
     * `CreateMembers` is always used to add accounts that are not organization members.
     *
     * For accounts that are managed using Organizations, `CreateMembers` is only used in the following cases:
     * + Security Hub is not configured to automatically add new organization accounts.
     * + The account was disassociated or deleted in Security Hub.
     *
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the `EnableSecurityHub` operation.
     *
     * For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the `InviteMembers` operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.
     *
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.
     * + If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.
     * + For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.
     *
     * A permissions policy is added that permits the administrator account to view the findings generated in the member account.
     *
     * To remove the association between the administrator and member accounts, use the `DisassociateFromMasterAccount` or `DisassociateMembers` operation.
     */
    suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse

    /**
     * Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
     *
     * `CreateMembers` is always used to add accounts that are not organization members.
     *
     * For accounts that are managed using Organizations, `CreateMembers` is only used in the following cases:
     * + Security Hub is not configured to automatically add new organization accounts.
     * + The account was disassociated or deleted in Security Hub.
     *
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the `EnableSecurityHub` operation.
     *
     * For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the `InviteMembers` operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.
     *
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.
     * + If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.
     * + For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.
     *
     * A permissions policy is added that permits the administrator account to view the findings generated in the member account.
     *
     * To remove the association between the administrator and member accounts, use the `DisassociateFromMasterAccount` or `DisassociateMembers` operation.
     */
    suspend fun createMembers(block: CreateMembersRequest.Builder.() -> Unit) = createMembers(CreateMembersRequest.Builder().apply(block).build())

    /**
     * Declines invitations to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse

    /**
     * Declines invitations to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    suspend fun declineInvitations(block: DeclineInvitationsRequest.Builder.() -> Unit) = declineInvitations(DeclineInvitationsRequest.Builder().apply(block).build())

    /**
     * Deletes a custom action target from Security Hub.
     *
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.
     */
    suspend fun deleteActionTarget(input: DeleteActionTargetRequest): DeleteActionTargetResponse

    /**
     * Deletes a custom action target from Security Hub.
     *
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.
     */
    suspend fun deleteActionTarget(block: DeleteActionTargetRequest.Builder.() -> Unit) = deleteActionTarget(DeleteActionTargetRequest.Builder().apply(block).build())

    /**
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     *
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated.
     */
    suspend fun deleteFindingAggregator(input: DeleteFindingAggregatorRequest): DeleteFindingAggregatorResponse

    /**
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     *
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated.
     */
    suspend fun deleteFindingAggregator(block: DeleteFindingAggregatorRequest.Builder.() -> Unit) = deleteFindingAggregator(DeleteFindingAggregatorRequest.Builder().apply(block).build())

    /**
     * Deletes the insight specified by the `InsightArn`.
     */
    suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse

    /**
     * Deletes the insight specified by the `InsightArn`.
     */
    suspend fun deleteInsight(block: DeleteInsightRequest.Builder.() -> Unit) = deleteInsight(DeleteInsightRequest.Builder().apply(block).build())

    /**
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse

    /**
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    suspend fun deleteInvitations(block: DeleteInvitationsRequest.Builder.() -> Unit) = deleteInvitations(DeleteInvitationsRequest.Builder().apply(block).build())

    /**
     * Deletes the specified member accounts from Security Hub.
     *
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited manually.
     */
    suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse

    /**
     * Deletes the specified member accounts from Security Hub.
     *
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited manually.
     */
    suspend fun deleteMembers(block: DeleteMembersRequest.Builder.() -> Unit) = deleteMembers(DeleteMembersRequest.Builder().apply(block).build())

    /**
     * Returns a list of the custom action targets in Security Hub in your account.
     */
    suspend fun describeActionTargets(input: DescribeActionTargetsRequest = DescribeActionTargetsRequest {}): DescribeActionTargetsResponse

    /**
     * Returns a list of the custom action targets in Security Hub in your account.
     */
    suspend fun describeActionTargets(block: DescribeActionTargetsRequest.Builder.() -> Unit) = describeActionTargets(DescribeActionTargetsRequest.Builder().apply(block).build())

    /**
     * Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
     */
    suspend fun describeHub(input: DescribeHubRequest = DescribeHubRequest {}): DescribeHubResponse

    /**
     * Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
     */
    suspend fun describeHub(block: DescribeHubRequest.Builder.() -> Unit) = describeHub(DescribeHubRequest.Builder().apply(block).build())

    /**
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
     */
    suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest = DescribeOrganizationConfigurationRequest {}): DescribeOrganizationConfigurationResponse

    /**
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
     */
    suspend fun describeOrganizationConfiguration(block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit) = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns information about product integrations in Security Hub.
     *
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.
     *
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     */
    suspend fun describeProducts(input: DescribeProductsRequest = DescribeProductsRequest {}): DescribeProductsResponse

    /**
     * Returns information about product integrations in Security Hub.
     *
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.
     *
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     */
    suspend fun describeProducts(block: DescribeProductsRequest.Builder.() -> Unit) = describeProducts(DescribeProductsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available standards in Security Hub.
     *
     * For each standard, the results include the standard ARN, the name, and a description.
     */
    suspend fun describeStandards(input: DescribeStandardsRequest = DescribeStandardsRequest {}): DescribeStandardsResponse

    /**
     * Returns a list of the available standards in Security Hub.
     *
     * For each standard, the results include the standard ARN, the name, and a description.
     */
    suspend fun describeStandards(block: DescribeStandardsRequest.Builder.() -> Unit) = describeStandards(DescribeStandardsRequest.Builder().apply(block).build())

    /**
     * Returns a list of security standards controls.
     *
     * For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.
     */
    suspend fun describeStandardsControls(input: DescribeStandardsControlsRequest): DescribeStandardsControlsResponse

    /**
     * Returns a list of security standards controls.
     *
     * For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.
     */
    suspend fun describeStandardsControls(block: DescribeStandardsControlsRequest.Builder.() -> Unit) = describeStandardsControls(DescribeStandardsControlsRequest.Builder().apply(block).build())

    /**
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
     */
    suspend fun disableImportFindingsForProduct(input: DisableImportFindingsForProductRequest): DisableImportFindingsForProductResponse

    /**
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
     */
    suspend fun disableImportFindingsForProduct(block: DisableImportFindingsForProductRequest.Builder.() -> Unit) = disableImportFindingsForProduct(DisableImportFindingsForProductRequest.Builder().apply(block).build())

    /**
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     */
    suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse

    /**
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     */
    suspend fun disableOrganizationAdminAccount(block: DisableOrganizationAdminAccountRequest.Builder.() -> Unit) = disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.Builder().apply(block).build())

    /**
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
     *
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated member accounts.
     *
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.
     *
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     */
    suspend fun disableSecurityHub(input: DisableSecurityHubRequest = DisableSecurityHubRequest {}): DisableSecurityHubResponse

    /**
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
     *
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated member accounts.
     *
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.
     *
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     */
    suspend fun disableSecurityHub(block: DisableSecurityHubRequest.Builder.() -> Unit) = disableSecurityHub(DisableSecurityHubRequest.Builder().apply(block).build())

    /**
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest = DisassociateFromAdministratorAccountRequest {}): DisassociateFromAdministratorAccountResponse

    /**
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    suspend fun disassociateFromAdministratorAccount(block: DisassociateFromAdministratorAccountRequest.Builder.() -> Unit) = disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.Builder().apply(block).build())

    /**
     * This method is deprecated. Instead, use `DisassociateFromAdministratorAccount`.
     *
     * The Security Hub console continues to use `DisassociateFromMasterAccount`. It will eventually change to use `DisassociateFromAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `DisassociateFromMasterAccount`. You should also add `DisassociateFromAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `DisassociateFromAdministratorAccount`.
     *
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest = DisassociateFromMasterAccountRequest {}): DisassociateFromMasterAccountResponse

    /**
     * This method is deprecated. Instead, use `DisassociateFromAdministratorAccount`.
     *
     * The Security Hub console continues to use `DisassociateFromMasterAccount`. It will eventually change to use `DisassociateFromAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `DisassociateFromMasterAccount`. You should also add `DisassociateFromAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `DisassociateFromAdministratorAccount`.
     *
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun disassociateFromMasterAccount(block: DisassociateFromMasterAccountRequest.Builder.() -> Unit) = disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified member accounts from the associated administrator account.
     *
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun disassociateMembers(input: DisassociateMembersRequest): DisassociateMembersResponse

    /**
     * Disassociates the specified member accounts from the associated administrator account.
     *
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun disassociateMembers(block: DisassociateMembersRequest.Builder.() -> Unit) = disassociateMembers(DisassociateMembersRequest.Builder().apply(block).build())

    /**
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
     *
     * When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.
     */
    suspend fun enableImportFindingsForProduct(input: EnableImportFindingsForProductRequest): EnableImportFindingsForProductResponse

    /**
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
     *
     * When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.
     */
    suspend fun enableImportFindingsForProduct(block: EnableImportFindingsForProductRequest.Builder.() -> Unit) = enableImportFindingsForProduct(EnableImportFindingsForProductRequest.Builder().apply(block).build())

    /**
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
     */
    suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse

    /**
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
     */
    suspend fun enableOrganizationAdminAccount(block: EnableOrganizationAdminAccountRequest.Builder.() -> Unit) = enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.Builder().apply(block).build())

    /**
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     *
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.
     *
     * When you use the `EnableSecurityHub` operation to enable Security Hub, you also automatically enable the following standards.
     * + CIS Amazon Web Services Foundations
     * + Amazon Web Services Foundational Security Best Practices
     *
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     *
     * To not enable the automatically enabled standards, set `EnableDefaultStandards` to `false`.
     *
     * After you enable Security Hub, to enable a standard, use the `BatchEnableStandards` operation. To disable a standard, use the `BatchDisableStandards` operation.
     *
     * To learn more, see the [setup information](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html) in the *Security Hub User Guide*.
     */
    suspend fun enableSecurityHub(input: EnableSecurityHubRequest = EnableSecurityHubRequest {}): EnableSecurityHubResponse

    /**
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     *
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.
     *
     * When you use the `EnableSecurityHub` operation to enable Security Hub, you also automatically enable the following standards.
     * + CIS Amazon Web Services Foundations
     * + Amazon Web Services Foundational Security Best Practices
     *
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     *
     * To not enable the automatically enabled standards, set `EnableDefaultStandards` to `false`.
     *
     * After you enable Security Hub, to enable a standard, use the `BatchEnableStandards` operation. To disable a standard, use the `BatchDisableStandards` operation.
     *
     * To learn more, see the [setup information](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html) in the *Security Hub User Guide*.
     */
    suspend fun enableSecurityHub(block: EnableSecurityHubRequest.Builder.() -> Unit) = enableSecurityHub(EnableSecurityHubRequest.Builder().apply(block).build())

    /**
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest = GetAdministratorAccountRequest {}): GetAdministratorAccountResponse

    /**
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun getAdministratorAccount(block: GetAdministratorAccountRequest.Builder.() -> Unit) = getAdministratorAccount(GetAdministratorAccountRequest.Builder().apply(block).build())

    /**
     * Returns a list of the standards that are currently enabled.
     */
    suspend fun getEnabledStandards(input: GetEnabledStandardsRequest = GetEnabledStandardsRequest {}): GetEnabledStandardsResponse

    /**
     * Returns a list of the standards that are currently enabled.
     */
    suspend fun getEnabledStandards(block: GetEnabledStandardsRequest.Builder.() -> Unit) = getEnabledStandards(GetEnabledStandardsRequest.Builder().apply(block).build())

    /**
     * Returns the current finding aggregation configuration.
     */
    suspend fun getFindingAggregator(input: GetFindingAggregatorRequest): GetFindingAggregatorResponse

    /**
     * Returns the current finding aggregation configuration.
     */
    suspend fun getFindingAggregator(block: GetFindingAggregatorRequest.Builder.() -> Unit) = getFindingAggregator(GetFindingAggregatorRequest.Builder().apply(block).build())

    /**
     * Returns a list of findings that match the specified criteria.
     *
     * If finding aggregation is enabled, then when you call `GetFindings` from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.
     */
    suspend fun getFindings(input: GetFindingsRequest = GetFindingsRequest {}): GetFindingsResponse

    /**
     * Returns a list of findings that match the specified criteria.
     *
     * If finding aggregation is enabled, then when you call `GetFindings` from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.
     */
    suspend fun getFindings(block: GetFindingsRequest.Builder.() -> Unit) = getFindings(GetFindingsRequest.Builder().apply(block).build())

    /**
     * Lists the results of the Security Hub insight specified by the insight ARN.
     */
    suspend fun getInsightResults(input: GetInsightResultsRequest): GetInsightResultsResponse

    /**
     * Lists the results of the Security Hub insight specified by the insight ARN.
     */
    suspend fun getInsightResults(block: GetInsightResultsRequest.Builder.() -> Unit) = getInsightResults(GetInsightResultsRequest.Builder().apply(block).build())

    /**
     * Lists and describes insights for the specified insight ARNs.
     */
    suspend fun getInsights(input: GetInsightsRequest = GetInsightsRequest {}): GetInsightsResponse

    /**
     * Lists and describes insights for the specified insight ARNs.
     */
    suspend fun getInsights(block: GetInsightsRequest.Builder.() -> Unit) = getInsights(GetInsightsRequest.Builder().apply(block).build())

    /**
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
     */
    suspend fun getInvitationsCount(input: GetInvitationsCountRequest = GetInvitationsCountRequest {}): GetInvitationsCountResponse

    /**
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
     */
    suspend fun getInvitationsCount(block: GetInvitationsCountRequest.Builder.() -> Unit) = getInvitationsCount(GetInvitationsCountRequest.Builder().apply(block).build())

    /**
     * This method is deprecated. Instead, use `GetAdministratorAccount`.
     *
     * The Security Hub console continues to use `GetMasterAccount`. It will eventually change to use `GetAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `GetMasterAccount`. You should also add `GetAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `GetAdministratorAccount`.
     *
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun getMasterAccount(input: GetMasterAccountRequest = GetMasterAccountRequest {}): GetMasterAccountResponse

    /**
     * This method is deprecated. Instead, use `GetAdministratorAccount`.
     *
     * The Security Hub console continues to use `GetMasterAccount`. It will eventually change to use `GetAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `GetMasterAccount`. You should also add `GetAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `GetAdministratorAccount`.
     *
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun getMasterAccount(block: GetMasterAccountRequest.Builder.() -> Unit) = getMasterAccount(GetMasterAccountRequest.Builder().apply(block).build())

    /**
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     *
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.
     *
     * The results include both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun getMembers(input: GetMembersRequest): GetMembersResponse

    /**
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     *
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.
     *
     * The results include both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    suspend fun getMembers(block: GetMembersRequest.Builder.() -> Unit) = getMembers(GetMembersRequest.Builder().apply(block).build())

    /**
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
     *
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.
     *
     * Before you can use this action to invite a member, you must first use the `CreateMembers` action to create the member account in Security Hub.
     *
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.
     */
    suspend fun inviteMembers(input: InviteMembersRequest): InviteMembersResponse

    /**
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
     *
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.
     *
     * Before you can use this action to invite a member, you must first use the `CreateMembers` action to create the member account in Security Hub.
     *
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.
     */
    suspend fun inviteMembers(block: InviteMembersRequest.Builder.() -> Unit) = inviteMembers(InviteMembersRequest.Builder().apply(block).build())

    /**
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
     */
    suspend fun listEnabledProductsForImport(input: ListEnabledProductsForImportRequest = ListEnabledProductsForImportRequest {}): ListEnabledProductsForImportResponse

    /**
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
     */
    suspend fun listEnabledProductsForImport(block: ListEnabledProductsForImportRequest.Builder.() -> Unit) = listEnabledProductsForImport(ListEnabledProductsForImportRequest.Builder().apply(block).build())

    /**
     * If finding aggregation is enabled, then `ListFindingAggregators` returns the ARN of the finding aggregator. You can run this operation from any Region.
     */
    suspend fun listFindingAggregators(input: ListFindingAggregatorsRequest = ListFindingAggregatorsRequest {}): ListFindingAggregatorsResponse

    /**
     * If finding aggregation is enabled, then `ListFindingAggregators` returns the ARN of the finding aggregator. You can run this operation from any Region.
     */
    suspend fun listFindingAggregators(block: ListFindingAggregatorsRequest.Builder.() -> Unit) = listFindingAggregators(ListFindingAggregatorsRequest.Builder().apply(block).build())

    /**
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     *
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.
     */
    suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest {}): ListInvitationsResponse

    /**
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     *
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.
     */
    suspend fun listInvitations(block: ListInvitationsRequest.Builder.() -> Unit) = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

    /**
     * Lists details about all member accounts for the current Security Hub administrator account.
     *
     * The results include both member accounts that belong to an organization and member accounts that were invited manually.
     */
    suspend fun listMembers(input: ListMembersRequest = ListMembersRequest {}): ListMembersResponse

    /**
     * Lists details about all member accounts for the current Security Hub administrator account.
     *
     * The results include both member accounts that belong to an organization and member accounts that were invited manually.
     */
    suspend fun listMembers(block: ListMembersRequest.Builder.() -> Unit) = listMembers(ListMembersRequest.Builder().apply(block).build())

    /**
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     */
    suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest {}): ListOrganizationAdminAccountsResponse

    /**
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     */
    suspend fun listOrganizationAdminAccounts(block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit) = listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags associated with a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tags associated with a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds one or more tags to a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the name and description of a custom action target in Security Hub.
     */
    suspend fun updateActionTarget(input: UpdateActionTargetRequest): UpdateActionTargetResponse

    /**
     * Updates the name and description of a custom action target in Security Hub.
     */
    suspend fun updateActionTarget(block: UpdateActionTargetRequest.Builder.() -> Unit) = updateActionTarget(UpdateActionTargetRequest.Builder().apply(block).build())

    /**
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use `UpdateFindingAggregator` to change the aggregation Region.
     *
     * You must run `UpdateFindingAggregator` from the current aggregation Region.
     */
    suspend fun updateFindingAggregator(input: UpdateFindingAggregatorRequest): UpdateFindingAggregatorResponse

    /**
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use `UpdateFindingAggregator` to change the aggregation Region.
     *
     * You must run `UpdateFindingAggregator` from the current aggregation Region.
     */
    suspend fun updateFindingAggregator(block: UpdateFindingAggregatorRequest.Builder.() -> Unit) = updateFindingAggregator(UpdateFindingAggregatorRequest.Builder().apply(block).build())

    /**
     * `UpdateFindings` is deprecated. Instead of `UpdateFindings`, use `BatchUpdateFindings`.
     *
     * Updates the `Note` and `RecordState` of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     */
    suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse

    /**
     * `UpdateFindings` is deprecated. Instead of `UpdateFindings`, use `BatchUpdateFindings`.
     *
     * Updates the `Note` and `RecordState` of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     */
    suspend fun updateFindings(block: UpdateFindingsRequest.Builder.() -> Unit) = updateFindings(UpdateFindingsRequest.Builder().apply(block).build())

    /**
     * Updates the Security Hub insight identified by the specified insight ARN.
     */
    suspend fun updateInsight(input: UpdateInsightRequest): UpdateInsightResponse

    /**
     * Updates the Security Hub insight identified by the specified insight ARN.
     */
    suspend fun updateInsight(block: UpdateInsightRequest.Builder.() -> Unit) = updateInsight(UpdateInsightRequest.Builder().apply(block).build())

    /**
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
     */
    suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse

    /**
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
     */
    suspend fun updateOrganizationConfiguration(block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit) = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates configuration options for Security Hub.
     */
    suspend fun updateSecurityHubConfiguration(input: UpdateSecurityHubConfigurationRequest = UpdateSecurityHubConfigurationRequest {}): UpdateSecurityHubConfigurationResponse

    /**
     * Updates configuration options for Security Hub.
     */
    suspend fun updateSecurityHubConfiguration(block: UpdateSecurityHubConfigurationRequest.Builder.() -> Unit) = updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest.Builder().apply(block).build())

    /**
     * Used to control whether an individual security standard control is enabled or disabled.
     */
    suspend fun updateStandardsControl(input: UpdateStandardsControlRequest): UpdateStandardsControlResponse

    /**
     * Used to control whether an individual security standard control is enabled or disabled.
     */
    suspend fun updateStandardsControl(block: UpdateStandardsControlRequest.Builder.() -> Unit) = updateStandardsControl(UpdateStandardsControlRequest.Builder().apply(block).build())
}
