// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.securityhub.model.*
import aws.sdk.kotlin.services.securityhub.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "SecurityHub"
const val ServiceApiVersion: String = "2018-10-26"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultSecurityHubClient(override val config: SecurityHubClient.Config) : SecurityHubClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    override suspend fun acceptAdministratorInvitation(input: AcceptAdministratorInvitationRequest): AcceptAdministratorInvitationResponse {
        val op = SdkHttpOperation.build<AcceptAdministratorInvitationRequest, AcceptAdministratorInvitationResponse> {
            serializer = AcceptAdministratorInvitationOperationSerializer()
            deserializer = AcceptAdministratorInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptAdministratorInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This method is deprecated. Instead, use `AcceptAdministratorInvitation`.
     *
     * The Security Hub console continues to use `AcceptInvitation`. It will eventually change to use `AcceptAdministratorInvitation`. Any IAM policies that specifically control access to this function must continue to use `AcceptInvitation`. You should also add `AcceptAdministratorInvitation` to your policies to ensure that the correct permissions are in place after the console begins to use `AcceptAdministratorInvitation`.
     *
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse {
        val op = SdkHttpOperation.build<AcceptInvitationRequest, AcceptInvitationResponse> {
            serializer = AcceptInvitationOperationSerializer()
            deserializer = AcceptInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the standards specified by the provided `StandardsSubscriptionArns`.
     *
     * For more information, see [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    override suspend fun batchDisableStandards(input: BatchDisableStandardsRequest): BatchDisableStandardsResponse {
        val op = SdkHttpOperation.build<BatchDisableStandardsRequest, BatchDisableStandardsResponse> {
            serializer = BatchDisableStandardsOperationSerializer()
            deserializer = BatchDisableStandardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisableStandards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the `DescribeStandards` operation.
     *
     * For more information, see the [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    override suspend fun batchEnableStandards(input: BatchEnableStandardsRequest): BatchEnableStandardsResponse {
        val op = SdkHttpOperation.build<BatchEnableStandardsRequest, BatchEnableStandardsResponse> {
            serializer = BatchEnableStandardsOperationSerializer()
            deserializer = BatchEnableStandardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchEnableStandards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
     *
     * `BatchImportFindings` must be called by one of the following:
     * + The Amazon Web Services account that is associated with a finding if you are using the [default product ARN](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs) or are a partner sending findings from within a customer's Amazon Web Services account. In these cases, the identifier of the account that you are calling `BatchImportFindings` from needs to be the same as the `AwsAccountId` attribute for the finding.
     * + An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call `BatchImportFindings` from the allow-listed account and send findings from different customer accounts in the same batch.
     *
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     *
     * After a finding is created, `BatchImportFindings` cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.
     * + `Note`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * Finding providers also should not use `BatchImportFindings` to update the following attributes.
     * + `Confidence`
     * + `Criticality`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     *
     * Instead, finding providers use `FindingProviderFields` to provide values for these attributes.
     */
    override suspend fun batchImportFindings(input: BatchImportFindingsRequest): BatchImportFindingsResponse {
        val op = SdkHttpOperation.build<BatchImportFindingsRequest, BatchImportFindingsResponse> {
            serializer = BatchImportFindingsOperationSerializer()
            deserializer = BatchImportFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchImportFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
     *
     * Updates from `BatchUpdateFindings` do not affect the value of `UpdatedAt` for a finding.
     *
     * Administrator and member accounts can use `BatchUpdateFindings` to update the following finding fields and objects.
     * + `Confidence`
     * + `Criticality`
     * + `Note`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See [Configuring access to BatchUpdateFindings](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access) in the *Security Hub User Guide*.
     */
    override suspend fun batchUpdateFindings(input: BatchUpdateFindingsRequest): BatchUpdateFindingsResponse {
        val op = SdkHttpOperation.build<BatchUpdateFindingsRequest, BatchUpdateFindingsResponse> {
            serializer = BatchUpdateFindingsOperationSerializer()
            deserializer = BatchUpdateFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom action target in Security Hub.
     *
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.
     */
    override suspend fun createActionTarget(input: CreateActionTargetRequest): CreateActionTargetResponse {
        val op = SdkHttpOperation.build<CreateActionTargetRequest, CreateActionTargetResponse> {
            serializer = CreateActionTargetOperationSerializer()
            deserializer = CreateActionTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateActionTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     *
     * For more details about cross-Region replication, see [Configuring finding aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *Security Hub User Guide*.
     */
    override suspend fun createFindingAggregator(input: CreateFindingAggregatorRequest): CreateFindingAggregatorResponse {
        val op = SdkHttpOperation.build<CreateFindingAggregatorRequest, CreateFindingAggregatorResponse> {
            serializer = CreateFindingAggregatorOperationSerializer()
            deserializer = CreateFindingAggregatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFindingAggregator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
     *
     * To group the related findings in the insight, use the `GroupByAttribute`.
     */
    override suspend fun createInsight(input: CreateInsightRequest): CreateInsightResponse {
        val op = SdkHttpOperation.build<CreateInsightRequest, CreateInsightResponse> {
            serializer = CreateInsightOperationSerializer()
            deserializer = CreateInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
     *
     * `CreateMembers` is always used to add accounts that are not organization members.
     *
     * For accounts that are managed using Organizations, `CreateMembers` is only used in the following cases:
     * + Security Hub is not configured to automatically add new organization accounts.
     * + The account was disassociated or deleted in Security Hub.
     *
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the `EnableSecurityHub` operation.
     *
     * For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the `InviteMembers` operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.
     *
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.
     * + If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.
     * + For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.
     *
     * A permissions policy is added that permits the administrator account to view the findings generated in the member account.
     *
     * To remove the association between the administrator and member accounts, use the `DisassociateFromMasterAccount` or `DisassociateMembers` operation.
     */
    override suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse {
        val op = SdkHttpOperation.build<CreateMembersRequest, CreateMembersResponse> {
            serializer = CreateMembersOperationSerializer()
            deserializer = CreateMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Declines invitations to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    override suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse {
        val op = SdkHttpOperation.build<DeclineInvitationsRequest, DeclineInvitationsResponse> {
            serializer = DeclineInvitationsOperationSerializer()
            deserializer = DeclineInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeclineInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom action target from Security Hub.
     *
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.
     */
    override suspend fun deleteActionTarget(input: DeleteActionTargetRequest): DeleteActionTargetResponse {
        val op = SdkHttpOperation.build<DeleteActionTargetRequest, DeleteActionTargetResponse> {
            serializer = DeleteActionTargetOperationSerializer()
            deserializer = DeleteActionTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteActionTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     *
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated.
     */
    override suspend fun deleteFindingAggregator(input: DeleteFindingAggregatorRequest): DeleteFindingAggregatorResponse {
        val op = SdkHttpOperation.build<DeleteFindingAggregatorRequest, DeleteFindingAggregatorResponse> {
            serializer = DeleteFindingAggregatorOperationSerializer()
            deserializer = DeleteFindingAggregatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFindingAggregator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the insight specified by the `InsightArn`.
     */
    override suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse {
        val op = SdkHttpOperation.build<DeleteInsightRequest, DeleteInsightResponse> {
            serializer = DeleteInsightOperationSerializer()
            deserializer = DeleteInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     *
     * This operation is only used by accounts that are not part of an organization. Organization accounts do not receive invitations.
     */
    override suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse {
        val op = SdkHttpOperation.build<DeleteInvitationsRequest, DeleteInvitationsResponse> {
            serializer = DeleteInvitationsOperationSerializer()
            deserializer = DeleteInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified member accounts from Security Hub.
     *
     * Can be used to delete member accounts that belong to an organization as well as member accounts that were invited manually.
     */
    override suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse {
        val op = SdkHttpOperation.build<DeleteMembersRequest, DeleteMembersResponse> {
            serializer = DeleteMembersOperationSerializer()
            deserializer = DeleteMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the custom action targets in Security Hub in your account.
     */
    override suspend fun describeActionTargets(input: DescribeActionTargetsRequest): DescribeActionTargetsResponse {
        val op = SdkHttpOperation.build<DescribeActionTargetsRequest, DescribeActionTargetsResponse> {
            serializer = DescribeActionTargetsOperationSerializer()
            deserializer = DescribeActionTargetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeActionTargets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
     */
    override suspend fun describeHub(input: DescribeHubRequest): DescribeHubResponse {
        val op = SdkHttpOperation.build<DescribeHubRequest, DescribeHubResponse> {
            serializer = DescribeHubOperationSerializer()
            deserializer = DescribeHubOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHub"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
     */
    override suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse> {
            serializer = DescribeOrganizationConfigurationOperationSerializer()
            deserializer = DescribeOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about product integrations in Security Hub.
     *
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.
     *
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     */
    override suspend fun describeProducts(input: DescribeProductsRequest): DescribeProductsResponse {
        val op = SdkHttpOperation.build<DescribeProductsRequest, DescribeProductsResponse> {
            serializer = DescribeProductsOperationSerializer()
            deserializer = DescribeProductsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeProducts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the available standards in Security Hub.
     *
     * For each standard, the results include the standard ARN, the name, and a description.
     */
    override suspend fun describeStandards(input: DescribeStandardsRequest): DescribeStandardsResponse {
        val op = SdkHttpOperation.build<DescribeStandardsRequest, DescribeStandardsResponse> {
            serializer = DescribeStandardsOperationSerializer()
            deserializer = DescribeStandardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStandards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of security standards controls.
     *
     * For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.
     */
    override suspend fun describeStandardsControls(input: DescribeStandardsControlsRequest): DescribeStandardsControlsResponse {
        val op = SdkHttpOperation.build<DescribeStandardsControlsRequest, DescribeStandardsControlsResponse> {
            serializer = DescribeStandardsControlsOperationSerializer()
            deserializer = DescribeStandardsControlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStandardsControls"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
     */
    override suspend fun disableImportFindingsForProduct(input: DisableImportFindingsForProductRequest): DisableImportFindingsForProductResponse {
        val op = SdkHttpOperation.build<DisableImportFindingsForProductRequest, DisableImportFindingsForProductResponse> {
            serializer = DisableImportFindingsForProductOperationSerializer()
            deserializer = DisableImportFindingsForProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableImportFindingsForProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     */
    override suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse> {
            serializer = DisableOrganizationAdminAccountOperationSerializer()
            deserializer = DisableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
     *
     * When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated member accounts.
     *
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.
     *
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     */
    override suspend fun disableSecurityHub(input: DisableSecurityHubRequest): DisableSecurityHubResponse {
        val op = SdkHttpOperation.build<DisableSecurityHubRequest, DisableSecurityHubResponse> {
            serializer = DisableSecurityHubOperationSerializer()
            deserializer = DisableSecurityHubOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableSecurityHub"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    override suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest): DisassociateFromAdministratorAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResponse> {
            serializer = DisassociateFromAdministratorAccountOperationSerializer()
            deserializer = DisassociateFromAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromAdministratorAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This method is deprecated. Instead, use `DisassociateFromAdministratorAccount`.
     *
     * The Security Hub console continues to use `DisassociateFromMasterAccount`. It will eventually change to use `DisassociateFromAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `DisassociateFromMasterAccount`. You should also add `DisassociateFromAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `DisassociateFromAdministratorAccount`.
     *
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest): DisassociateFromMasterAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse> {
            serializer = DisassociateFromMasterAccountOperationSerializer()
            deserializer = DisassociateFromMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromMasterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified member accounts from the associated administrator account.
     *
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.
     */
    override suspend fun disassociateMembers(input: DisassociateMembersRequest): DisassociateMembersResponse {
        val op = SdkHttpOperation.build<DisassociateMembersRequest, DisassociateMembersResponse> {
            serializer = DisassociateMembersOperationSerializer()
            deserializer = DisassociateMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
     *
     * When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.
     */
    override suspend fun enableImportFindingsForProduct(input: EnableImportFindingsForProductRequest): EnableImportFindingsForProductResponse {
        val op = SdkHttpOperation.build<EnableImportFindingsForProductRequest, EnableImportFindingsForProductResponse> {
            serializer = EnableImportFindingsForProductOperationSerializer()
            deserializer = EnableImportFindingsForProductOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableImportFindingsForProduct"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
     */
    override suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse> {
            serializer = EnableOrganizationAdminAccountOperationSerializer()
            deserializer = EnableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     *
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.
     *
     * When you use the `EnableSecurityHub` operation to enable Security Hub, you also automatically enable the following standards.
     * + CIS Amazon Web Services Foundations
     * + Amazon Web Services Foundational Security Best Practices
     *
     * You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.
     *
     * To not enable the automatically enabled standards, set `EnableDefaultStandards` to `false`.
     *
     * After you enable Security Hub, to enable a standard, use the `BatchEnableStandards` operation. To disable a standard, use the `BatchDisableStandards` operation.
     *
     * To learn more, see the [setup information](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html) in the *Security Hub User Guide*.
     */
    override suspend fun enableSecurityHub(input: EnableSecurityHubRequest): EnableSecurityHubResponse {
        val op = SdkHttpOperation.build<EnableSecurityHubRequest, EnableSecurityHubResponse> {
            serializer = EnableSecurityHubOperationSerializer()
            deserializer = EnableSecurityHubOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableSecurityHub"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    override suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest): GetAdministratorAccountResponse {
        val op = SdkHttpOperation.build<GetAdministratorAccountRequest, GetAdministratorAccountResponse> {
            serializer = GetAdministratorAccountOperationSerializer()
            deserializer = GetAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAdministratorAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the standards that are currently enabled.
     */
    override suspend fun getEnabledStandards(input: GetEnabledStandardsRequest): GetEnabledStandardsResponse {
        val op = SdkHttpOperation.build<GetEnabledStandardsRequest, GetEnabledStandardsResponse> {
            serializer = GetEnabledStandardsOperationSerializer()
            deserializer = GetEnabledStandardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEnabledStandards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the current finding aggregation configuration.
     */
    override suspend fun getFindingAggregator(input: GetFindingAggregatorRequest): GetFindingAggregatorResponse {
        val op = SdkHttpOperation.build<GetFindingAggregatorRequest, GetFindingAggregatorResponse> {
            serializer = GetFindingAggregatorOperationSerializer()
            deserializer = GetFindingAggregatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingAggregator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of findings that match the specified criteria.
     *
     * If finding aggregation is enabled, then when you call `GetFindings` from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.
     */
    override suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse {
        val op = SdkHttpOperation.build<GetFindingsRequest, GetFindingsResponse> {
            serializer = GetFindingsOperationSerializer()
            deserializer = GetFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the results of the Security Hub insight specified by the insight ARN.
     */
    override suspend fun getInsightResults(input: GetInsightResultsRequest): GetInsightResultsResponse {
        val op = SdkHttpOperation.build<GetInsightResultsRequest, GetInsightResultsResponse> {
            serializer = GetInsightResultsOperationSerializer()
            deserializer = GetInsightResultsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightResults"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists and describes insights for the specified insight ARNs.
     */
    override suspend fun getInsights(input: GetInsightsRequest): GetInsightsResponse {
        val op = SdkHttpOperation.build<GetInsightsRequest, GetInsightsResponse> {
            serializer = GetInsightsOperationSerializer()
            deserializer = GetInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
     */
    override suspend fun getInvitationsCount(input: GetInvitationsCountRequest): GetInvitationsCountResponse {
        val op = SdkHttpOperation.build<GetInvitationsCountRequest, GetInvitationsCountResponse> {
            serializer = GetInvitationsCountOperationSerializer()
            deserializer = GetInvitationsCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInvitationsCount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * This method is deprecated. Instead, use `GetAdministratorAccount`.
     *
     * The Security Hub console continues to use `GetMasterAccount`. It will eventually change to use `GetAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `GetMasterAccount`. You should also add `GetAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `GetAdministratorAccount`.
     *
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun getMasterAccount(input: GetMasterAccountRequest): GetMasterAccountResponse {
        val op = SdkHttpOperation.build<GetMasterAccountRequest, GetMasterAccountResponse> {
            serializer = GetMasterAccountOperationSerializer()
            deserializer = GetMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMasterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     *
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.
     *
     * The results include both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    override suspend fun getMembers(input: GetMembersRequest): GetMembersResponse {
        val op = SdkHttpOperation.build<GetMembersRequest, GetMembersResponse> {
            serializer = GetMembersOperationSerializer()
            deserializer = GetMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
     *
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.
     *
     * Before you can use this action to invite a member, you must first use the `CreateMembers` action to create the member account in Security Hub.
     *
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.
     */
    override suspend fun inviteMembers(input: InviteMembersRequest): InviteMembersResponse {
        val op = SdkHttpOperation.build<InviteMembersRequest, InviteMembersResponse> {
            serializer = InviteMembersOperationSerializer()
            deserializer = InviteMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "InviteMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
     */
    override suspend fun listEnabledProductsForImport(input: ListEnabledProductsForImportRequest): ListEnabledProductsForImportResponse {
        val op = SdkHttpOperation.build<ListEnabledProductsForImportRequest, ListEnabledProductsForImportResponse> {
            serializer = ListEnabledProductsForImportOperationSerializer()
            deserializer = ListEnabledProductsForImportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEnabledProductsForImport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If finding aggregation is enabled, then `ListFindingAggregators` returns the ARN of the finding aggregator. You can run this operation from any Region.
     */
    override suspend fun listFindingAggregators(input: ListFindingAggregatorsRequest): ListFindingAggregatorsResponse {
        val op = SdkHttpOperation.build<ListFindingAggregatorsRequest, ListFindingAggregatorsResponse> {
            serializer = ListFindingAggregatorsOperationSerializer()
            deserializer = ListFindingAggregatorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindingAggregators"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     *
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.
     */
    override suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse {
        val op = SdkHttpOperation.build<ListInvitationsRequest, ListInvitationsResponse> {
            serializer = ListInvitationsOperationSerializer()
            deserializer = ListInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists details about all member accounts for the current Security Hub administrator account.
     *
     * The results include both member accounts that belong to an organization and member accounts that were invited manually.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     */
    override suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest): ListOrganizationAdminAccountsResponse {
        val op = SdkHttpOperation.build<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse> {
            serializer = ListOrganizationAdminAccountsOperationSerializer()
            deserializer = ListOrganizationAdminAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationAdminAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags associated with a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name and description of a custom action target in Security Hub.
     */
    override suspend fun updateActionTarget(input: UpdateActionTargetRequest): UpdateActionTargetResponse {
        val op = SdkHttpOperation.build<UpdateActionTargetRequest, UpdateActionTargetResponse> {
            serializer = UpdateActionTargetOperationSerializer()
            deserializer = UpdateActionTargetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateActionTarget"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use `UpdateFindingAggregator` to change the aggregation Region.
     *
     * You must run `UpdateFindingAggregator` from the current aggregation Region.
     */
    override suspend fun updateFindingAggregator(input: UpdateFindingAggregatorRequest): UpdateFindingAggregatorResponse {
        val op = SdkHttpOperation.build<UpdateFindingAggregatorRequest, UpdateFindingAggregatorResponse> {
            serializer = UpdateFindingAggregatorOperationSerializer()
            deserializer = UpdateFindingAggregatorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFindingAggregator"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * `UpdateFindings` is deprecated. Instead of `UpdateFindings`, use `BatchUpdateFindings`.
     *
     * Updates the `Note` and `RecordState` of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     */
    override suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse {
        val op = SdkHttpOperation.build<UpdateFindingsRequest, UpdateFindingsResponse> {
            serializer = UpdateFindingsOperationSerializer()
            deserializer = UpdateFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Security Hub insight identified by the specified insight ARN.
     */
    override suspend fun updateInsight(input: UpdateInsightRequest): UpdateInsightResponse {
        val op = SdkHttpOperation.build<UpdateInsightRequest, UpdateInsightResponse> {
            serializer = UpdateInsightOperationSerializer()
            deserializer = UpdateInsightOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInsight"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
     */
    override suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse> {
            serializer = UpdateOrganizationConfigurationOperationSerializer()
            deserializer = UpdateOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates configuration options for Security Hub.
     */
    override suspend fun updateSecurityHubConfiguration(input: UpdateSecurityHubConfigurationRequest): UpdateSecurityHubConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateSecurityHubConfigurationRequest, UpdateSecurityHubConfigurationResponse> {
            serializer = UpdateSecurityHubConfigurationOperationSerializer()
            deserializer = UpdateSecurityHubConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSecurityHubConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Used to control whether an individual security standard control is enabled or disabled.
     */
    override suspend fun updateStandardsControl(input: UpdateStandardsControlRequest): UpdateStandardsControlResponse {
        val op = SdkHttpOperation.build<UpdateStandardsControlRequest, UpdateStandardsControlResponse> {
            serializer = UpdateStandardsControlOperationSerializer()
            deserializer = UpdateStandardsControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStandardsControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "securityhub"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "securityhub")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
