// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class UpdateSecretRequest private constructor(builder: Builder) {
    /**
     * If you include `SecretString` or `SecretBinary`, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.
     *
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
     *
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
     *
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The description of the secret.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions with the staging labels `AWSCURRENT`, `AWSPENDING`, or `AWSPREVIOUS`. If you don't have `kms:Encrypt` permission to the new key, Secrets Manager does not re-ecrypt existing secret versions with the new key. For more information about versions and staging labels, see [Concepts: Version](https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
     *
     * A key alias is always prefixed by `alias/`, for example `alias/aws/secretsmanager`. For more information, see [About aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
     *
     * If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key `aws/secretsmanager`. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use `aws/secretsmanager`. Creating `aws/secretsmanager` can result in a one-time significant delay in returning the result.
     *
     * You can only use the Amazon Web Services managed key `aws/secretsmanager` if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
     *
     * Either `SecretBinary` or `SecretString` must have a value, but not both.
     *
     * You can't access this parameter in the Secrets Manager console.
     */
    public val secretBinary: kotlin.ByteArray? = builder.secretBinary
    /**
     * The ARN or name of the secret.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId
    /**
     * The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.
     *
     * Either `SecretBinary` or `SecretString` must have a value, but not both.
     */
    public val secretString: kotlin.String? = builder.secretString

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSecretRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("secretBinary=*** Sensitive Data Redacted ***,")
        append("secretId=$secretId,")
        append("secretString=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (secretBinary?.contentHashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        result = 31 * result + (secretString?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSecretRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (secretBinary != null) {
            if (other.secretBinary == null) return false
            if (!secretBinary.contentEquals(other.secretBinary)) return false
        } else if (other.secretBinary != null) return false
        if (secretId != other.secretId) return false
        if (secretString != other.secretString) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If you include `SecretString` or `SecretBinary`, then Secrets Manager creates a new version for the secret, and this parameter specifies the unique identifier for the new version.
         *
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
         *
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
         *
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The description of the secret.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any existing versions with the staging labels `AWSCURRENT`, `AWSPENDING`, or `AWSPREVIOUS`. If you don't have `kms:Encrypt` permission to the new key, Secrets Manager does not re-ecrypt existing secret versions with the new key. For more information about versions and staging labels, see [Concepts: Version](https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version).
         *
         * A key alias is always prefixed by `alias/`, for example `alias/aws/secretsmanager`. For more information, see [About aliases](https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html).
         *
         * If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key `aws/secretsmanager`. If this key doesn't already exist in your account, then Secrets Manager creates it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use `aws/secretsmanager`. Creating `aws/secretsmanager` can result in a one-time significant delay in returning the result.
         *
         * You can only use the Amazon Web Services managed key `aws/secretsmanager` if you call this operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user making the call must have permissions to both the secret and the KMS key in their respective accounts.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
         *
         * Either `SecretBinary` or `SecretString` must have a value, but not both.
         *
         * You can't access this parameter in the Secrets Manager console.
         */
        public var secretBinary: kotlin.ByteArray? = null
        /**
         * The ARN or name of the secret.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null
        /**
         * The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of key/value pairs for your secret value.
         *
         * Either `SecretBinary` or `SecretString` must have a value, but not both.
         */
        public var secretString: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.secretBinary = x.secretBinary
            this.secretId = x.secretId
            this.secretString = x.secretString
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretRequest = UpdateSecretRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
