// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains information about one version of a secret.
 */
public class SecretVersionsListEntry private constructor(builder: Builder) {
    /**
     * The date and time this version of the secret was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The KMS keys used to encrypt the secret version.
     */
    public val kmsKeyIds: List<String>? = builder.kmsKeyIds
    /**
     * The date that this version of the secret was last accessed. Note that the resolution of this field is at the date level and does not include the time.
     */
    public val lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedDate
    /**
     * The unique version identifier of this version of the secret.
     */
    public val versionId: kotlin.String? = builder.versionId
    /**
     * An array of staging labels that are currently associated with this version of the secret.
     */
    public val versionStages: List<String>? = builder.versionStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.SecretVersionsListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretVersionsListEntry(")
        append("createdDate=$createdDate,")
        append("kmsKeyIds=$kmsKeyIds,")
        append("lastAccessedDate=$lastAccessedDate,")
        append("versionId=$versionId,")
        append("versionStages=$versionStages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (kmsKeyIds?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedDate?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (versionStages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretVersionsListEntry

        if (createdDate != other.createdDate) return false
        if (kmsKeyIds != other.kmsKeyIds) return false
        if (lastAccessedDate != other.lastAccessedDate) return false
        if (versionId != other.versionId) return false
        if (versionStages != other.versionStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.SecretVersionsListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time this version of the secret was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The KMS keys used to encrypt the secret version.
         */
        public var kmsKeyIds: List<String>? = null
        /**
         * The date that this version of the secret was last accessed. Note that the resolution of this field is at the date level and does not include the time.
         */
        public var lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique version identifier of this version of the secret.
         */
        public var versionId: kotlin.String? = null
        /**
         * An array of staging labels that are currently associated with this version of the secret.
         */
        public var versionStages: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.SecretVersionsListEntry) : this() {
            this.createdDate = x.createdDate
            this.kmsKeyIds = x.kmsKeyIds
            this.lastAccessedDate = x.lastAccessedDate
            this.versionId = x.versionId
            this.versionStages = x.versionStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.SecretVersionsListEntry = SecretVersionsListEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
