// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains the secret value and other details for a secret.
 */
public class SecretValueEntry private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the secret.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date the secret was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The friendly name of the secret.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The decrypted secret value, if the secret value was originally provided as binary data in the form of a byte array. The parameter represents the binary data as a [base64-encoded](https://tools.ietf.org/html/rfc4648#section-4) string.
     */
    public val secretBinary: kotlin.ByteArray? = builder.secretBinary
    /**
     * The decrypted secret value, if the secret value was originally provided as a string or through the Secrets Manager console.
     */
    public val secretString: kotlin.String? = builder.secretString
    /**
     * The unique version identifier of this version of the secret.
     */
    public val versionId: kotlin.String? = builder.versionId
    /**
     * A list of all of the staging labels currently attached to this version of the secret.
     */
    public val versionStages: List<String>? = builder.versionStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.SecretValueEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretValueEntry(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("name=$name,")
        append("secretBinary=*** Sensitive Data Redacted ***,")
        append("secretString=*** Sensitive Data Redacted ***,")
        append("versionId=$versionId,")
        append("versionStages=$versionStages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (secretBinary?.contentHashCode() ?: 0)
        result = 31 * result + (secretString?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (versionStages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretValueEntry

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (name != other.name) return false
        if (secretBinary != null) {
            if (other.secretBinary == null) return false
            if (!secretBinary.contentEquals(other.secretBinary)) return false
        } else if (other.secretBinary != null) return false
        if (secretString != other.secretString) return false
        if (versionId != other.versionId) return false
        if (versionStages != other.versionStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.SecretValueEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the secret.
         */
        public var arn: kotlin.String? = null
        /**
         * The date the secret was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The friendly name of the secret.
         */
        public var name: kotlin.String? = null
        /**
         * The decrypted secret value, if the secret value was originally provided as binary data in the form of a byte array. The parameter represents the binary data as a [base64-encoded](https://tools.ietf.org/html/rfc4648#section-4) string.
         */
        public var secretBinary: kotlin.ByteArray? = null
        /**
         * The decrypted secret value, if the secret value was originally provided as a string or through the Secrets Manager console.
         */
        public var secretString: kotlin.String? = null
        /**
         * The unique version identifier of this version of the secret.
         */
        public var versionId: kotlin.String? = null
        /**
         * A list of all of the staging labels currently attached to this version of the secret.
         */
        public var versionStages: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.SecretValueEntry) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.name = x.name
            this.secretBinary = x.secretBinary
            this.secretString = x.secretString
            this.versionId = x.versionId
            this.versionStages = x.versionStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.SecretValueEntry = SecretValueEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
