// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains the details about a secret. It does not include the encrypted `SecretString` and `SecretBinary` values. To get those values, use [GetSecretValue](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_GetSecretValue.html) .
 */
public class SecretListEntry private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the secret.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time when a secret was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The date and time the deletion of the secret occurred. Not present on active secrets. The secret can be recovered until the number of days in the recovery window has passed, as specified in the `RecoveryWindowInDays` parameter of the `DeleteSecret`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_DeleteSecret.html) operation.
     */
    public val deletedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedDate
    /**
     * The user-provided description of the secret.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is encrypted with the Amazon Web Services managed key `aws/secretsmanager`, this field is omitted.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
     */
    public val lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedDate
    /**
     * The last date and time that this secret was modified in any way.
     */
    public val lastChangedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastChangedDate
    /**
     * The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn't ever rotated.
     */
    public val lastRotatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRotatedDate
    /**
     * The friendly name of the secret.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The next rotation is scheduled to occur on or before this date. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
     */
    public val nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.nextRotationDate
    /**
     * Returns the name of the service that created the secret.
     */
    public val owningService: kotlin.String? = builder.owningService
    /**
     * The Region where Secrets Manager originated the secret.
     */
    public val primaryRegion: kotlin.String? = builder.primaryRegion
    /**
     * Indicates whether automatic, scheduled rotation is enabled for this secret.
     */
    public val rotationEnabled: kotlin.Boolean? = builder.rotationEnabled
    /**
     * The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the secret either automatically per the schedule or manually by a call to `RotateSecret`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_RotateSecret.html).
     */
    public val rotationLambdaArn: kotlin.String? = builder.rotationLambdaArn
    /**
     * A structure that defines the rotation configuration for the secret.
     */
    public val rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = builder.rotationRules
    /**
     * A list of all of the currently assigned `SecretVersionStage` staging labels and the `SecretVersionId` attached to each one. Staging labels are used to keep track of the different versions during the rotation process.
     *
     * A version that does not have any `SecretVersionStage` is considered deprecated and subject to deletion. Such versions are not included in this list.
     */
    public val secretVersionsToStages: Map<String, List<String>>? = builder.secretVersionsToStages
    /**
     * The list of user-defined tags associated with the secret. To add tags to a secret, use `TagResource`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_TagResource.html). To remove tags, use `UntagResource`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_UntagResource.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.SecretListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecretListEntry(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("deletedDate=$deletedDate,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastAccessedDate=$lastAccessedDate,")
        append("lastChangedDate=$lastChangedDate,")
        append("lastRotatedDate=$lastRotatedDate,")
        append("name=$name,")
        append("nextRotationDate=$nextRotationDate,")
        append("owningService=$owningService,")
        append("primaryRegion=$primaryRegion,")
        append("rotationEnabled=$rotationEnabled,")
        append("rotationLambdaArn=$rotationLambdaArn,")
        append("rotationRules=$rotationRules,")
        append("secretVersionsToStages=$secretVersionsToStages,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (deletedDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedDate?.hashCode() ?: 0)
        result = 31 * result + (lastChangedDate?.hashCode() ?: 0)
        result = 31 * result + (lastRotatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextRotationDate?.hashCode() ?: 0)
        result = 31 * result + (owningService?.hashCode() ?: 0)
        result = 31 * result + (primaryRegion?.hashCode() ?: 0)
        result = 31 * result + (rotationEnabled?.hashCode() ?: 0)
        result = 31 * result + (rotationLambdaArn?.hashCode() ?: 0)
        result = 31 * result + (rotationRules?.hashCode() ?: 0)
        result = 31 * result + (secretVersionsToStages?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecretListEntry

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (deletedDate != other.deletedDate) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastAccessedDate != other.lastAccessedDate) return false
        if (lastChangedDate != other.lastChangedDate) return false
        if (lastRotatedDate != other.lastRotatedDate) return false
        if (name != other.name) return false
        if (nextRotationDate != other.nextRotationDate) return false
        if (owningService != other.owningService) return false
        if (primaryRegion != other.primaryRegion) return false
        if (rotationEnabled != other.rotationEnabled) return false
        if (rotationLambdaArn != other.rotationLambdaArn) return false
        if (rotationRules != other.rotationRules) return false
        if (secretVersionsToStages != other.secretVersionsToStages) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.SecretListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the secret.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time when a secret was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the deletion of the secret occurred. Not present on active secrets. The secret can be recovered until the number of days in the recovery window has passed, as specified in the `RecoveryWindowInDays` parameter of the `DeleteSecret`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_DeleteSecret.html) operation.
         */
        public var deletedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-provided description of the secret.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is encrypted with the Amazon Web Services managed key `aws/secretsmanager`, this field is omitted.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
         */
        public var lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date and time that this secret was modified in any way.
         */
        public var lastChangedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent date and time that the Secrets Manager rotation process was successfully completed. This value is null if the secret hasn't ever rotated.
         */
        public var lastRotatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The friendly name of the secret.
         */
        public var name: kotlin.String? = null
        /**
         * The next rotation is scheduled to occur on or before this date. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
         */
        public var nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the name of the service that created the secret.
         */
        public var owningService: kotlin.String? = null
        /**
         * The Region where Secrets Manager originated the secret.
         */
        public var primaryRegion: kotlin.String? = null
        /**
         * Indicates whether automatic, scheduled rotation is enabled for this secret.
         */
        public var rotationEnabled: kotlin.Boolean? = null
        /**
         * The ARN of an Amazon Web Services Lambda function invoked by Secrets Manager to rotate and expire the secret either automatically per the schedule or manually by a call to `RotateSecret`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_RotateSecret.html).
         */
        public var rotationLambdaArn: kotlin.String? = null
        /**
         * A structure that defines the rotation configuration for the secret.
         */
        public var rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = null
        /**
         * A list of all of the currently assigned `SecretVersionStage` staging labels and the `SecretVersionId` attached to each one. Staging labels are used to keep track of the different versions during the rotation process.
         *
         * A version that does not have any `SecretVersionStage` is considered deprecated and subject to deletion. Such versions are not included in this list.
         */
        public var secretVersionsToStages: Map<String, List<String>>? = null
        /**
         * The list of user-defined tags associated with the secret. To add tags to a secret, use `TagResource`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_TagResource.html). To remove tags, use `UntagResource`[](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_UntagResource.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.SecretListEntry) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.deletedDate = x.deletedDate
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.lastAccessedDate = x.lastAccessedDate
            this.lastChangedDate = x.lastChangedDate
            this.lastRotatedDate = x.lastRotatedDate
            this.name = x.name
            this.nextRotationDate = x.nextRotationDate
            this.owningService = x.owningService
            this.primaryRegion = x.primaryRegion
            this.rotationEnabled = x.rotationEnabled
            this.rotationLambdaArn = x.rotationLambdaArn
            this.rotationRules = x.rotationRules
            this.secretVersionsToStages = x.secretVersionsToStages
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.SecretListEntry = SecretListEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType] inside the given [block]
         */
        public fun rotationRules(block: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.Builder.() -> kotlin.Unit) {
            this.rotationRules = aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
