// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class RotateSecretRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the new version of the secret. You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice.
     *
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
     *
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
     *
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in RotateSecretRequest$RotationRules.
     *
     * For secrets that use a Lambda rotation function to rotate, if you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the `testSecret`[ step](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html) of the Lambda rotation function. The test creates an `AWSPENDING` version of the secret and then removes it.
     *
     * By default, Secrets Manager rotates the secret immediately.
     */
    public val rotateImmediately: kotlin.Boolean? = builder.rotateImmediately
    /**
     * For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function.
     *
     * For secrets that use *managed rotation*, omit this field. For more information, see [Managed rotation](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html) in the *Secrets Manager User Guide*.
     */
    public val rotationLambdaArn: kotlin.String? = builder.rotationLambdaArn
    /**
     * A structure that defines the rotation configuration for this secret.
     */
    public val rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = builder.rotationRules
    /**
     * The ARN or name of the secret to rotate.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.RotateSecretRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RotateSecretRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("rotateImmediately=$rotateImmediately,")
        append("rotationLambdaArn=$rotationLambdaArn,")
        append("rotationRules=$rotationRules,")
        append("secretId=$secretId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (rotateImmediately?.hashCode() ?: 0)
        result = 31 * result + (rotationLambdaArn?.hashCode() ?: 0)
        result = 31 * result + (rotationRules?.hashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RotateSecretRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (rotateImmediately != other.rotateImmediately) return false
        if (rotationLambdaArn != other.rotationLambdaArn) return false
        if (rotationRules != other.rotationRules) return false
        if (secretId != other.secretId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.RotateSecretRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the new version of the secret. You only need to specify this value if you implement your own retry logic and you want to ensure that Secrets Manager doesn't attempt to create a secret version twice.
         *
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
         *
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
         *
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Specifies whether to rotate the secret immediately or wait until the next scheduled rotation window. The rotation schedule is defined in RotateSecretRequest$RotationRules.
         *
         * For secrets that use a Lambda rotation function to rotate, if you don't immediately rotate the secret, Secrets Manager tests the rotation configuration by running the `testSecret`[ step](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html) of the Lambda rotation function. The test creates an `AWSPENDING` version of the secret and then removes it.
         *
         * By default, Secrets Manager rotates the secret immediately.
         */
        public var rotateImmediately: kotlin.Boolean? = null
        /**
         * For secrets that use a Lambda rotation function to rotate, the ARN of the Lambda rotation function.
         *
         * For secrets that use *managed rotation*, omit this field. For more information, see [Managed rotation](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_managed.html) in the *Secrets Manager User Guide*.
         */
        public var rotationLambdaArn: kotlin.String? = null
        /**
         * A structure that defines the rotation configuration for this secret.
         */
        public var rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = null
        /**
         * The ARN or name of the secret to rotate.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.RotateSecretRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.rotateImmediately = x.rotateImmediately
            this.rotationLambdaArn = x.rotationLambdaArn
            this.rotationRules = x.rotationRules
            this.secretId = x.secretId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.RotateSecretRequest = RotateSecretRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType] inside the given [block]
         */
        public fun rotationRules(block: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.Builder.() -> kotlin.Unit) {
            this.rotationRules = aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
