// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A replication object consisting of a `RegionReplicationStatus` object and includes a Region, KMSKeyId, status, and status message.
 */
public class ReplicationStatusType private constructor(builder: Builder) {
    /**
     * Can be an `ARN`, `Key ID`, or `Alias`.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
     */
    public val lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedDate
    /**
     * The Region where replication occurs.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The status can be `InProgress`, `Failed`, or `InSync`.
     */
    public val status: aws.sdk.kotlin.services.secretsmanager.model.StatusType? = builder.status
    /**
     * Status message such as "*Secret with this name already exists in this region*".
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.ReplicationStatusType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationStatusType(")
        append("kmsKeyId=$kmsKeyId,")
        append("lastAccessedDate=$lastAccessedDate,")
        append("region=$region,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (lastAccessedDate?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationStatusType

        if (kmsKeyId != other.kmsKeyId) return false
        if (lastAccessedDate != other.lastAccessedDate) return false
        if (region != other.region) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.ReplicationStatusType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Can be an `ARN`, `Key ID`, or `Alias`.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
         */
        public var lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Region where replication occurs.
         */
        public var region: kotlin.String? = null
        /**
         * The status can be `InProgress`, `Failed`, or `InSync`.
         */
        public var status: aws.sdk.kotlin.services.secretsmanager.model.StatusType? = null
        /**
         * Status message such as "*Secret with this name already exists in this region*".
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.ReplicationStatusType) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.lastAccessedDate = x.lastAccessedDate
            this.region = x.region
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.ReplicationStatusType = ReplicationStatusType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
