// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class ListSecretVersionIdsRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager. By default, versions without staging labels aren't included.
     */
    public val includeDeprecated: kotlin.Boolean? = builder.includeDeprecated
    /**
     * The number of results to include in the response.
     *
     * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `ListSecretVersionIds` again with the value from `NextToken`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `ListSecretVersionIds` again with this value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN or name of the secret whose versions you want to list.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSecretVersionIdsRequest(")
        append("includeDeprecated=$includeDeprecated,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("secretId=$secretId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeDeprecated?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSecretVersionIdsRequest

        if (includeDeprecated != other.includeDeprecated) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (secretId != other.secretId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to include versions of secrets that don't have any staging labels attached to them. Versions without staging labels are considered deprecated and are subject to deletion by Secrets Manager. By default, versions without staging labels aren't included.
         */
        public var includeDeprecated: kotlin.Boolean? = null
        /**
         * The number of results to include in the response.
         *
         * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `ListSecretVersionIds` again with the value from `NextToken`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `ListSecretVersionIds` again with this value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN or name of the secret whose versions you want to list.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsRequest) : this() {
            this.includeDeprecated = x.includeDeprecated
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.secretId = x.secretId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsRequest = ListSecretVersionIdsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
