// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeSecretResponse private constructor(builder: Builder) {
    /**
     * The ARN of the secret.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date the secret was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is omitted. When you delete a secret, Secrets Manager requires a recovery window of at least 7 days before deleting the secret. Some time after the deleted date, Secrets Manager deletes the secret, including all of its versions.
     *
     * If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not accessible. To cancel a scheduled deletion and restore access to the secret, use RestoreSecret.
     */
    public val deletedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.deletedDate
    /**
     * The description of the secret.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is encrypted with the Amazon Web Services managed key `aws/secretsmanager`, this field is omitted. Secrets created using the console use an KMS key ID.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
     */
    public val lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAccessedDate
    /**
     * The last date and time that this secret was modified in any way.
     */
    public val lastChangedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastChangedDate
    /**
     * The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
     */
    public val lastRotatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRotatedDate
    /**
     * The name of the secret.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The next rotation is scheduled to occur on or before this date. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
     */
    public val nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.nextRotationDate
    /**
     * The ID of the service that created this secret. For more information, see [Secrets managed by other Amazon Web Services services](https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
     */
    public val owningService: kotlin.String? = builder.owningService
    /**
     * The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in `ReplicationStatus`.
     */
    public val primaryRegion: kotlin.String? = builder.primaryRegion
    /**
     * A list of the replicas of this secret and their status:
     * + `Failed`, which indicates that the replica was not created.
     * + `InProgress`, which indicates that Secrets Manager is in the process of creating the replica.
     * + `InSync`, which indicates that the replica was created.
     */
    public val replicationStatus: List<ReplicationStatusType>? = builder.replicationStatus
    /**
     * Specifies whether automatic rotation is turned on for this secret.
     *
     * To turn on rotation, use RotateSecret. To turn off rotation, use CancelRotateSecret.
     */
    public val rotationEnabled: kotlin.Boolean? = builder.rotationEnabled
    /**
     * The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
     */
    public val rotationLambdaArn: kotlin.String? = builder.rotationLambdaArn
    /**
     * The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on, but it is now turned off, this field shows the previous rotation schedule and rotation function. If the secret never had rotation turned on, this field is omitted.
     */
    public val rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = builder.rotationRules
    /**
     * The list of tags attached to the secret. To add tags to a secret, use TagResource. To remove tags, use UntagResource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of the versions of the secret that have staging labels attached. Versions that don't have staging labels are considered deprecated and Secrets Manager can delete them.
     *
     * Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three staging labels for rotation are:
     * + `AWSCURRENT`, which indicates the current version of the secret.
     * + `AWSPENDING`, which indicates the version of the secret that contains new secret information that will become the next current version when rotation finishes.During rotation, Secrets Manager creates an `AWSPENDING` version ID before creating the new secret version. To check if a secret version exists, call GetSecretValue.
     * + `AWSPREVIOUS`, which indicates the previous current version of the secret. You can use this as the *last known good* version.
     *
     * For more information about rotation and staging labels, see [How rotation works](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html).
     */
    public val versionIdsToStages: Map<String, List<String>>? = builder.versionIdsToStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.DescribeSecretResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeSecretResponse(")
        append("arn=$arn,")
        append("createdDate=$createdDate,")
        append("deletedDate=$deletedDate,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastAccessedDate=$lastAccessedDate,")
        append("lastChangedDate=$lastChangedDate,")
        append("lastRotatedDate=$lastRotatedDate,")
        append("name=$name,")
        append("nextRotationDate=$nextRotationDate,")
        append("owningService=$owningService,")
        append("primaryRegion=$primaryRegion,")
        append("replicationStatus=$replicationStatus,")
        append("rotationEnabled=$rotationEnabled,")
        append("rotationLambdaArn=$rotationLambdaArn,")
        append("rotationRules=$rotationRules,")
        append("tags=$tags,")
        append("versionIdsToStages=$versionIdsToStages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (deletedDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastAccessedDate?.hashCode() ?: 0)
        result = 31 * result + (lastChangedDate?.hashCode() ?: 0)
        result = 31 * result + (lastRotatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextRotationDate?.hashCode() ?: 0)
        result = 31 * result + (owningService?.hashCode() ?: 0)
        result = 31 * result + (primaryRegion?.hashCode() ?: 0)
        result = 31 * result + (replicationStatus?.hashCode() ?: 0)
        result = 31 * result + (rotationEnabled?.hashCode() ?: 0)
        result = 31 * result + (rotationLambdaArn?.hashCode() ?: 0)
        result = 31 * result + (rotationRules?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionIdsToStages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeSecretResponse

        if (arn != other.arn) return false
        if (createdDate != other.createdDate) return false
        if (deletedDate != other.deletedDate) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastAccessedDate != other.lastAccessedDate) return false
        if (lastChangedDate != other.lastChangedDate) return false
        if (lastRotatedDate != other.lastRotatedDate) return false
        if (name != other.name) return false
        if (nextRotationDate != other.nextRotationDate) return false
        if (owningService != other.owningService) return false
        if (primaryRegion != other.primaryRegion) return false
        if (replicationStatus != other.replicationStatus) return false
        if (rotationEnabled != other.rotationEnabled) return false
        if (rotationLambdaArn != other.rotationLambdaArn) return false
        if (rotationRules != other.rotationRules) return false
        if (tags != other.tags) return false
        if (versionIdsToStages != other.versionIdsToStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.DescribeSecretResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the secret.
         */
        public var arn: kotlin.String? = null
        /**
         * The date the secret was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date the secret is scheduled for deletion. If it is not scheduled for deletion, this field is omitted. When you delete a secret, Secrets Manager requires a recovery window of at least 7 days before deleting the secret. Some time after the deleted date, Secrets Manager deletes the secret, including all of its versions.
         *
         * If a secret is scheduled for deletion, then its details, including the encrypted secret value, is not accessible. To cancel a scheduled deletion and restore access to the secret, use RestoreSecret.
         */
        public var deletedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the secret.
         */
        public var description: kotlin.String? = null
        /**
         * The key ID or alias ARN of the KMS key that Secrets Manager uses to encrypt the secret value. If the secret is encrypted with the Amazon Web Services managed key `aws/secretsmanager`, this field is omitted. Secrets created using the console use an KMS key ID.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The date that the secret was last accessed in the Region. This field is omitted if the secret has never been retrieved in the Region.
         */
        public var lastAccessedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date and time that this secret was modified in any way.
         */
        public var lastChangedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last date and time that Secrets Manager rotated the secret. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
         */
        public var lastRotatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the secret.
         */
        public var name: kotlin.String? = null
        /**
         * The next rotation is scheduled to occur on or before this date. If the secret isn't configured for rotation or rotation has been disabled, Secrets Manager returns null.
         */
        public var nextRotationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the service that created this secret. For more information, see [Secrets managed by other Amazon Web Services services](https://docs.aws.amazon.com/secretsmanager/latest/userguide/service-linked-secrets.html).
         */
        public var owningService: kotlin.String? = null
        /**
         * The Region the secret is in. If a secret is replicated to other Regions, the replicas are listed in `ReplicationStatus`.
         */
        public var primaryRegion: kotlin.String? = null
        /**
         * A list of the replicas of this secret and their status:
         * + `Failed`, which indicates that the replica was not created.
         * + `InProgress`, which indicates that Secrets Manager is in the process of creating the replica.
         * + `InSync`, which indicates that the replica was created.
         */
        public var replicationStatus: List<ReplicationStatusType>? = null
        /**
         * Specifies whether automatic rotation is turned on for this secret.
         *
         * To turn on rotation, use RotateSecret. To turn off rotation, use CancelRotateSecret.
         */
        public var rotationEnabled: kotlin.Boolean? = null
        /**
         * The ARN of the Lambda function that Secrets Manager invokes to rotate the secret.
         */
        public var rotationLambdaArn: kotlin.String? = null
        /**
         * The rotation schedule and Lambda function for this secret. If the secret previously had rotation turned on, but it is now turned off, this field shows the previous rotation schedule and rotation function. If the secret never had rotation turned on, this field is omitted.
         */
        public var rotationRules: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType? = null
        /**
         * The list of tags attached to the secret. To add tags to a secret, use TagResource. To remove tags, use UntagResource.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of the versions of the secret that have staging labels attached. Versions that don't have staging labels are considered deprecated and Secrets Manager can delete them.
         *
         * Secrets Manager uses staging labels to indicate the status of a secret version during rotation. The three staging labels for rotation are:
         * + `AWSCURRENT`, which indicates the current version of the secret.
         * + `AWSPENDING`, which indicates the version of the secret that contains new secret information that will become the next current version when rotation finishes.During rotation, Secrets Manager creates an `AWSPENDING` version ID before creating the new secret version. To check if a secret version exists, call GetSecretValue.
         * + `AWSPREVIOUS`, which indicates the previous current version of the secret. You can use this as the *last known good* version.
         *
         * For more information about rotation and staging labels, see [How rotation works](https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotate-secrets_how.html).
         */
        public var versionIdsToStages: Map<String, List<String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.DescribeSecretResponse) : this() {
            this.arn = x.arn
            this.createdDate = x.createdDate
            this.deletedDate = x.deletedDate
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.lastAccessedDate = x.lastAccessedDate
            this.lastChangedDate = x.lastChangedDate
            this.lastRotatedDate = x.lastRotatedDate
            this.name = x.name
            this.nextRotationDate = x.nextRotationDate
            this.owningService = x.owningService
            this.primaryRegion = x.primaryRegion
            this.replicationStatus = x.replicationStatus
            this.rotationEnabled = x.rotationEnabled
            this.rotationLambdaArn = x.rotationLambdaArn
            this.rotationRules = x.rotationRules
            this.tags = x.tags
            this.versionIdsToStages = x.versionIdsToStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.DescribeSecretResponse = DescribeSecretResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType] inside the given [block]
         */
        public fun rotationRules(block: aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.Builder.() -> kotlin.Unit) {
            this.rotationRules = aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
