// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class DeleteSecretRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to delete the secret without any recovery window. You can't use both this parameter and `RecoveryWindowInDays` in the same call. If you don't use either, then by default Secrets Manager uses a 30 day recovery window.
     *
     * Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.
     *
     * If you forcibly delete an already deleted or nonexistent secret, the operation does not return `ResourceNotFoundException`.
     *
     * Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the `RecoveryWindowInDays` parameter. If you delete a secret with the `ForceDeleteWithoutRecovery` parameter, then you have no opportunity to recover the secret. You lose the secret permanently.
     */
    public val forceDeleteWithoutRecovery: kotlin.Boolean? = builder.forceDeleteWithoutRecovery
    /**
     * The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and `ForceDeleteWithoutRecovery` in the same call. If you don't use either, then by default Secrets Manager uses a 30 day recovery window.
     */
    public val recoveryWindowInDays: kotlin.Long? = builder.recoveryWindowInDays
    /**
     * The ARN or name of the secret to delete.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.DeleteSecretRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteSecretRequest(")
        append("forceDeleteWithoutRecovery=$forceDeleteWithoutRecovery,")
        append("recoveryWindowInDays=$recoveryWindowInDays,")
        append("secretId=$secretId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = forceDeleteWithoutRecovery?.hashCode() ?: 0
        result = 31 * result + (recoveryWindowInDays?.hashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteSecretRequest

        if (forceDeleteWithoutRecovery != other.forceDeleteWithoutRecovery) return false
        if (recoveryWindowInDays != other.recoveryWindowInDays) return false
        if (secretId != other.secretId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.DeleteSecretRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to delete the secret without any recovery window. You can't use both this parameter and `RecoveryWindowInDays` in the same call. If you don't use either, then by default Secrets Manager uses a 30 day recovery window.
         *
         * Secrets Manager performs the actual deletion with an asynchronous background process, so there might be a short delay before the secret is permanently deleted. If you delete a secret and then immediately create a secret with the same name, use appropriate back off and retry logic.
         *
         * If you forcibly delete an already deleted or nonexistent secret, the operation does not return `ResourceNotFoundException`.
         *
         * Use this parameter with caution. This parameter causes the operation to skip the normal recovery window before the permanent deletion that Secrets Manager would normally impose with the `RecoveryWindowInDays` parameter. If you delete a secret with the `ForceDeleteWithoutRecovery` parameter, then you have no opportunity to recover the secret. You lose the secret permanently.
         */
        public var forceDeleteWithoutRecovery: kotlin.Boolean? = null
        /**
         * The number of days from 7 to 30 that Secrets Manager waits before permanently deleting the secret. You can't use both this parameter and `ForceDeleteWithoutRecovery` in the same call. If you don't use either, then by default Secrets Manager uses a 30 day recovery window.
         */
        public var recoveryWindowInDays: kotlin.Long? = null
        /**
         * The ARN or name of the secret to delete.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.DeleteSecretRequest) : this() {
            this.forceDeleteWithoutRecovery = x.forceDeleteWithoutRecovery
            this.recoveryWindowInDays = x.recoveryWindowInDays
            this.secretId = x.secretId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.DeleteSecretRequest = DeleteSecretRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
