// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class CreateSecretResponse private constructor(builder: Builder) {
    /**
     * The ARN of the new secret. The ARN includes the name of the secret followed by six random characters. This ensures that if you create a new secret with the same name as a deleted secret, then users with access to the old secret don't get access to the new secret because the ARNs are different.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The name of the new secret.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of the replicas of this secret and their status:
     * + `Failed`, which indicates that the replica was not created.
     * + `InProgress`, which indicates that Secrets Manager is in the process of creating the replica.
     * + `InSync`, which indicates that the replica was created.
     */
    public val replicationStatus: List<ReplicationStatusType>? = builder.replicationStatus
    /**
     * The unique identifier associated with the version of the new secret.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSecretResponse(")
        append("arn=$arn,")
        append("name=$name,")
        append("replicationStatus=$replicationStatus,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (replicationStatus?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSecretResponse

        if (arn != other.arn) return false
        if (name != other.name) return false
        if (replicationStatus != other.replicationStatus) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the new secret. The ARN includes the name of the secret followed by six random characters. This ensures that if you create a new secret with the same name as a deleted secret, then users with access to the old secret don't get access to the new secret because the ARNs are different.
         */
        public var arn: kotlin.String? = null
        /**
         * The name of the new secret.
         */
        public var name: kotlin.String? = null
        /**
         * A list of the replicas of this secret and their status:
         * + `Failed`, which indicates that the replica was not created.
         * + `InProgress`, which indicates that Secrets Manager is in the process of creating the replica.
         * + `InSync`, which indicates that the replica was created.
         */
        public var replicationStatus: List<ReplicationStatusType>? = null
        /**
         * The unique identifier associated with the version of the new secret.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.CreateSecretResponse) : this() {
            this.arn = x.arn
            this.name = x.name
            this.replicationStatus = x.replicationStatus
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.CreateSecretResponse = CreateSecretResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
