// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class BatchGetSecretValueRequest private constructor(builder: Builder) {
    /**
     * The filters to choose which secrets to retrieve. You must include `Filters` or `SecretIdList`, but not both.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The number of results to include in the response.
     *
     * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `BatchGetSecretValue` again with the value from `NextToken`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `BatchGetSecretValue` again with this value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN or names of the secrets to retrieve. You must include `Filters` or `SecretIdList`, but not both.
     */
    public val secretIdList: List<String>? = builder.secretIdList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.BatchGetSecretValueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetSecretValueRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("secretIdList=$secretIdList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (secretIdList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetSecretValueRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (secretIdList != other.secretIdList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.BatchGetSecretValueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters to choose which secrets to retrieve. You must include `Filters` or `SecretIdList`, but not both.
         */
        public var filters: List<Filter>? = null
        /**
         * The number of results to include in the response.
         *
         * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `BatchGetSecretValue` again with the value from `NextToken`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `BatchGetSecretValue` again with this value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ARN or names of the secrets to retrieve. You must include `Filters` or `SecretIdList`, but not both.
         */
        public var secretIdList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.BatchGetSecretValueRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.secretIdList = x.secretIdList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.BatchGetSecretValueRequest = BatchGetSecretValueRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
