// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.serde

import aws.sdk.kotlin.services.secretsmanager.model.SecretsManagerException
import aws.sdk.kotlin.services.secretsmanager.model.ValidateResourcePolicyResponse
import aws.sdk.kotlin.services.secretsmanager.model.ValidationErrorsEntry
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ValidateResourcePolicyOperationDeserializer: HttpDeserialize<ValidateResourcePolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ValidateResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwValidateResourcePolicyError(context, call)
        }
        val builder = ValidateResourcePolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeValidateResourcePolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwValidateResourcePolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SecretsManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "MalformedPolicyDocumentException" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall)
        else -> SecretsManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeValidateResourcePolicyOperationBody(builder: ValidateResourcePolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val POLICYVALIDATIONPASSED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("PolicyValidationPassed"))
    val VALIDATIONERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ValidationErrors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(POLICYVALIDATIONPASSED_DESCRIPTOR)
        field(VALIDATIONERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                POLICYVALIDATIONPASSED_DESCRIPTOR.index -> builder.policyValidationPassed = deserializeBoolean()
                VALIDATIONERRORS_DESCRIPTOR.index -> builder.validationErrors =
                    deserializer.deserializeList(VALIDATIONERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ValidationErrorsEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeValidationErrorsEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
