// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.serde

import aws.sdk.kotlin.services.secretsmanager.model.RotateSecretRequest
import aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RotateSecretOperationSerializer: HttpSerialize<RotateSecretRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RotateSecretRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeRotateSecretOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeRotateSecretOperationBody(context: ExecutionContext, input: RotateSecretRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val ROTATEIMMEDIATELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("RotateImmediately"))
    val ROTATIONLAMBDAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationLambdaARN"))
    val ROTATIONRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RotationRules"))
    val SECRETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(ROTATEIMMEDIATELY_DESCRIPTOR)
        field(ROTATIONLAMBDAARN_DESCRIPTOR)
        field(ROTATIONRULES_DESCRIPTOR)
        field(SECRETID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.rotateImmediately?.let { field(ROTATEIMMEDIATELY_DESCRIPTOR, it) }
        input.rotationLambdaArn?.let { field(ROTATIONLAMBDAARN_DESCRIPTOR, it) }
        input.rotationRules?.let { field(ROTATIONRULES_DESCRIPTOR, it, ::serializeRotationRulesTypeDocument) }
        input.secretId?.let { field(SECRETID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
