// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.serde

import aws.sdk.kotlin.services.secretsmanager.model.DescribeSecretResponse
import aws.sdk.kotlin.services.secretsmanager.model.ReplicationStatusType
import aws.sdk.kotlin.services.secretsmanager.model.RotationRulesType
import aws.sdk.kotlin.services.secretsmanager.model.SecretsManagerException
import aws.sdk.kotlin.services.secretsmanager.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeSecretOperationDeserializer: HttpDeserialize<DescribeSecretResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeSecretResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeSecretError(context, call)
        }
        val builder = DescribeSecretResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSecretOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeSecretError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SecretsManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall)
        else -> SecretsManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSecretOperationBody(builder: DescribeSecretResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ARN"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val DELETEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeletedDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val LASTACCESSEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastAccessedDate"))
    val LASTCHANGEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastChangedDate"))
    val LASTROTATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastRotatedDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val NEXTROTATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("NextRotationDate"))
    val OWNINGSERVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwningService"))
    val PRIMARYREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PrimaryRegion"))
    val REPLICATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReplicationStatus"))
    val ROTATIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("RotationEnabled"))
    val ROTATIONLAMBDAARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationLambdaARN"))
    val ROTATIONRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RotationRules"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERSIONIDSTOSTAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("VersionIdsToStages"))
    val VERSIONIDSTOSTAGES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DELETEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(LASTACCESSEDDATE_DESCRIPTOR)
        field(LASTCHANGEDDATE_DESCRIPTOR)
        field(LASTROTATEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NEXTROTATIONDATE_DESCRIPTOR)
        field(OWNINGSERVICE_DESCRIPTOR)
        field(PRIMARYREGION_DESCRIPTOR)
        field(REPLICATIONSTATUS_DESCRIPTOR)
        field(ROTATIONENABLED_DESCRIPTOR)
        field(ROTATIONLAMBDAARN_DESCRIPTOR)
        field(ROTATIONRULES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSIONIDSTOSTAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DELETEDDATE_DESCRIPTOR.index -> builder.deletedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                LASTACCESSEDDATE_DESCRIPTOR.index -> builder.lastAccessedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTCHANGEDDATE_DESCRIPTOR.index -> builder.lastChangedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTROTATEDDATE_DESCRIPTOR.index -> builder.lastRotatedDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NEXTROTATIONDATE_DESCRIPTOR.index -> builder.nextRotationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                OWNINGSERVICE_DESCRIPTOR.index -> builder.owningService = deserializeString()
                PRIMARYREGION_DESCRIPTOR.index -> builder.primaryRegion = deserializeString()
                REPLICATIONSTATUS_DESCRIPTOR.index -> builder.replicationStatus =
                    deserializer.deserializeList(REPLICATIONSTATUS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReplicationStatusType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReplicationStatusTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROTATIONENABLED_DESCRIPTOR.index -> builder.rotationEnabled = deserializeBoolean()
                ROTATIONLAMBDAARN_DESCRIPTOR.index -> builder.rotationLambdaArn = deserializeString()
                ROTATIONRULES_DESCRIPTOR.index -> builder.rotationRules = deserializeRotationRulesTypeDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VERSIONIDSTOSTAGES_DESCRIPTOR.index -> builder.versionIdsToStages =
                    deserializer.deserializeMap(VERSIONIDSTOSTAGES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(VERSIONIDSTOSTAGES_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
