// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.paginators

import aws.sdk.kotlin.services.secretsmanager.SecretsManagerClient
import aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsRequest
import aws.sdk.kotlin.services.secretsmanager.model.ListSecretVersionIdsResponse
import aws.sdk.kotlin.services.secretsmanager.model.ListSecretsRequest
import aws.sdk.kotlin.services.secretsmanager.model.ListSecretsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecretsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecretsResponse]
 */
public fun SecretsManagerClient.listSecretsPaginated(initialRequest: ListSecretsRequest = ListSecretsRequest { }): Flow<ListSecretsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecretsPaginated.listSecrets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecretsResponse]
 */
public fun SecretsManagerClient.listSecretsPaginated(block: ListSecretsRequest.Builder.() -> Unit): Flow<ListSecretsResponse> =
    listSecretsPaginated(ListSecretsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSecretVersionIdsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecretVersionIdsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecretVersionIdsResponse]
 */
public fun SecretsManagerClient.listSecretVersionIdsPaginated(initialRequest: ListSecretVersionIdsRequest): Flow<ListSecretVersionIdsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecretVersionIdsPaginated.listSecretVersionIds(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSecretVersionIdsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecretVersionIdsResponse]
 */
public fun SecretsManagerClient.listSecretVersionIdsPaginated(block: ListSecretVersionIdsRequest.Builder.() -> Unit): Flow<ListSecretVersionIdsResponse> =
    listSecretVersionIdsPaginated(ListSecretVersionIdsRequest.Builder().apply(block).build())
