// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class UntagResourceRequest private constructor(builder: Builder) {
    /**
     * The ARN or name of the secret.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId
    /**
     * A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.
     *
     * This parameter requires a JSON text string argument.
     *
     * For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see [Specifying parameter values for the Amazon Web Services CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html) in the Amazon Web Services CLI User Guide.
     */
    public val tagKeys: List<String>? = builder.tagKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.UntagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UntagResourceRequest(")
        append("secretId=$secretId,")
        append("tagKeys=$tagKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = secretId?.hashCode() ?: 0
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UntagResourceRequest

        if (secretId != other.secretId) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.UntagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN or name of the secret.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null
        /**
         * A list of tag key names to remove from the secret. You don't specify the value. Both the key and its associated value are removed.
         *
         * This parameter requires a JSON text string argument.
         *
         * For storing multiple values, we recommend that you use a JSON text string argument and specify key/value pairs. For more information, see [Specifying parameter values for the Amazon Web Services CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html) in the Amazon Web Services CLI User Guide.
         */
        public var tagKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.UntagResourceRequest) : this() {
            this.secretId = x.secretId
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.UntagResourceRequest = UntagResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
