// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class PutSecretValueRequest private constructor(builder: Builder) {
    /**
     * A unique identifier for the new version of the secret.
     *
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
     *
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
     *
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
     * + If the `ClientRequestToken` value isn't already associated with a version of the secret then a new version of the secret is created.
     * + If a version with this value already exists and that version's `SecretString` or `SecretBinary` values are the same as those in the request then the request is ignored. The operation is idempotent.
     * + If a version with this value already exists and the version of the `SecretString` and `SecretBinary` values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.
     *
     * This value becomes the `VersionId` of the new version.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
     *
     * You must include `SecretBinary` or `SecretString`, but not both.
     *
     * You can't access this value from the Secrets Manager console.
     */
    public val secretBinary: kotlin.ByteArray? = builder.secretBinary
    /**
     * The ARN or name of the secret to add a new version to.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     *
     * If the secret doesn't already exist, use `CreateSecret` instead.
     */
    public val secretId: kotlin.String? = builder.secretId
    /**
     * The text to encrypt and store in the new version of the secret.
     *
     * You must include `SecretBinary` or `SecretString`, but not both.
     *
     * We recommend you create the secret string as JSON key/value pairs, as shown in the example.
     */
    public val secretString: kotlin.String? = builder.secretString
    /**
     * A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.
     *
     * If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify `AWSCURRENT`, and it is already attached to another version, then Secrets Manager also moves the staging label `AWSPREVIOUS` to the version that `AWSCURRENT` was removed from.
     *
     * If you don't include `VersionStages`, then Secrets Manager automatically moves the staging label `AWSCURRENT` to this version.
     */
    public val versionStages: List<String>? = builder.versionStages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.PutSecretValueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutSecretValueRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("secretBinary=*** Sensitive Data Redacted ***,")
        append("secretId=$secretId,")
        append("secretString=*** Sensitive Data Redacted ***,")
        append("versionStages=$versionStages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (secretBinary?.contentHashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        result = 31 * result + (secretString?.hashCode() ?: 0)
        result = 31 * result + (versionStages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutSecretValueRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (secretBinary != null) {
            if (other.secretBinary == null) return false
            if (!secretBinary.contentEquals(other.secretBinary)) return false
        } else if (other.secretBinary != null) return false
        if (secretId != other.secretId) return false
        if (secretString != other.secretString) return false
        if (versionStages != other.versionStages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.PutSecretValueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the new version of the secret.
         *
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for this parameter in the request.
         *
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a `ClientRequestToken` and include it in the request.
         *
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures and retries during a rotation. We recommend that you generate a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value to ensure uniqueness of your versions within the specified secret.
         * + If the `ClientRequestToken` value isn't already associated with a version of the secret then a new version of the secret is created.
         * + If a version with this value already exists and that version's `SecretString` or `SecretBinary` values are the same as those in the request then the request is ignored. The operation is idempotent.
         * + If a version with this value already exists and the version of the `SecretString` and `SecretBinary` values are different from those in the request, then the request fails because you can't modify a secret version. You can only create new versions to store new secret values.
         *
         * This value becomes the `VersionId` of the new version.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The binary data to encrypt and store in the new version of the secret. To use this parameter in the command-line tools, we recommend that you store your binary data in a file and then pass the contents of the file as a parameter.
         *
         * You must include `SecretBinary` or `SecretString`, but not both.
         *
         * You can't access this value from the Secrets Manager console.
         */
        public var secretBinary: kotlin.ByteArray? = null
        /**
         * The ARN or name of the secret to add a new version to.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         *
         * If the secret doesn't already exist, use `CreateSecret` instead.
         */
        public var secretId: kotlin.String? = null
        /**
         * The text to encrypt and store in the new version of the secret.
         *
         * You must include `SecretBinary` or `SecretString`, but not both.
         *
         * We recommend you create the secret string as JSON key/value pairs, as shown in the example.
         */
        public var secretString: kotlin.String? = null
        /**
         * A list of staging labels to attach to this version of the secret. Secrets Manager uses staging labels to track versions of a secret through the rotation process.
         *
         * If you specify a staging label that's already associated with a different version of the same secret, then Secrets Manager removes the label from the other version and attaches it to this version. If you specify `AWSCURRENT`, and it is already attached to another version, then Secrets Manager also moves the staging label `AWSPREVIOUS` to the version that `AWSCURRENT` was removed from.
         *
         * If you don't include `VersionStages`, then Secrets Manager automatically moves the staging label `AWSCURRENT` to this version.
         */
        public var versionStages: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.PutSecretValueRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.secretBinary = x.secretBinary
            this.secretId = x.secretId
            this.secretString = x.secretString
            this.versionStages = x.versionStages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.PutSecretValueRequest = PutSecretValueRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
