// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class PutResourcePolicyRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to block resource-based policies that allow broad access to the secret, for example those that use a wildcard for the principal. By default, public policies aren't blocked.
     */
    public val blockPublicPolicy: kotlin.Boolean? = builder.blockPublicPolicy
    /**
     * A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see [Permissions policy examples](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
     */
    public val resourcePolicy: kotlin.String? = builder.resourcePolicy
    /**
     * The ARN or name of the secret to attach the resource-based policy.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.PutResourcePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutResourcePolicyRequest(")
        append("blockPublicPolicy=$blockPublicPolicy,")
        append("resourcePolicy=$resourcePolicy,")
        append("secretId=$secretId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicPolicy?.hashCode() ?: 0
        result = 31 * result + (resourcePolicy?.hashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutResourcePolicyRequest

        if (blockPublicPolicy != other.blockPublicPolicy) return false
        if (resourcePolicy != other.resourcePolicy) return false
        if (secretId != other.secretId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.PutResourcePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether to block resource-based policies that allow broad access to the secret, for example those that use a wildcard for the principal. By default, public policies aren't blocked.
         */
        public var blockPublicPolicy: kotlin.Boolean? = null
        /**
         * A JSON-formatted string for an Amazon Web Services resource-based policy. For example policies, see [Permissions policy examples](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html).
         */
        public var resourcePolicy: kotlin.String? = null
        /**
         * The ARN or name of the secret to attach the resource-based policy.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.PutResourcePolicyRequest) : this() {
            this.blockPublicPolicy = x.blockPublicPolicy
            this.resourcePolicy = x.resourcePolicy
            this.secretId = x.secretId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.PutResourcePolicyRequest = PutResourcePolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
