// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class ListSecretsRequest private constructor(builder: Builder) {
    /**
     * The filters to apply to the list of secrets.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * Specifies whether to include secrets scheduled for deletion. By default, secrets scheduled for deletion aren't included.
     */
    public val includePlannedDeletion: kotlin.Boolean? = builder.includePlannedDeletion
    /**
     * The number of results to include in the response.
     *
     * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `ListSecrets` again with the value from `NextToken`.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `ListSecrets` again with this value.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Secrets are listed by `CreatedDate`.
     */
    public val sortOrder: aws.sdk.kotlin.services.secretsmanager.model.SortOrderType? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.ListSecretsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSecretsRequest(")
        append("filters=$filters,")
        append("includePlannedDeletion=$includePlannedDeletion,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (includePlannedDeletion?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSecretsRequest

        if (filters != other.filters) return false
        if (includePlannedDeletion != other.includePlannedDeletion) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.ListSecretsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters to apply to the list of secrets.
         */
        public var filters: List<Filter>? = null
        /**
         * Specifies whether to include secrets scheduled for deletion. By default, secrets scheduled for deletion aren't included.
         */
        public var includePlannedDeletion: kotlin.Boolean? = null
        /**
         * The number of results to include in the response.
         *
         * If there are more results available, in the response, Secrets Manager includes `NextToken`. To get the next results, call `ListSecrets` again with the value from `NextToken`.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token that indicates where the output should continue from, if a previous call did not show all results. To get the next results, call `ListSecrets` again with this value.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Secrets are listed by `CreatedDate`.
         */
        public var sortOrder: aws.sdk.kotlin.services.secretsmanager.model.SortOrderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.ListSecretsRequest) : this() {
            this.filters = x.filters
            this.includePlannedDeletion = x.includePlannedDeletion
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.ListSecretsRequest = ListSecretsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
