// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.serde

import aws.sdk.kotlin.services.secretsmanager.model.PutSecretValueRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.encodeBase64String


internal class PutSecretValueOperationSerializer: HttpSerialize<PutSecretValueRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutSecretValueRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutSecretValueOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePutSecretValueOperationBody(context: ExecutionContext, input: PutSecretValueRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTREQUESTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientRequestToken"))
    val SECRETBINARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("SecretBinary"))
    val SECRETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretId"))
    val SECRETSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretString"))
    val VERSIONSTAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("VersionStages"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTREQUESTTOKEN_DESCRIPTOR)
        field(SECRETBINARY_DESCRIPTOR)
        field(SECRETID_DESCRIPTOR)
        field(SECRETSTRING_DESCRIPTOR)
        field(VERSIONSTAGES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientRequestToken?.let { field(CLIENTREQUESTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTREQUESTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.secretBinary?.let { field(SECRETBINARY_DESCRIPTOR, it.encodeBase64String()) }
        input.secretId?.let { field(SECRETID_DESCRIPTOR, it) }
        input.secretString?.let { field(SECRETSTRING_DESCRIPTOR, it) }
        if (input.versionStages != null) {
            listField(VERSIONSTAGES_DESCRIPTOR) {
                for (el0 in input.versionStages) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
