// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.serde

import aws.sdk.kotlin.services.secretsmanager.model.GetSecretValueResponse
import aws.sdk.kotlin.services.secretsmanager.model.SecretsManagerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes
import kotlin.collections.mutableListOf


internal class GetSecretValueOperationDeserializer: HttpDeserialize<GetSecretValueResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetSecretValueResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSecretValueError(context, call)
        }
        val builder = GetSecretValueResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSecretValueOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetSecretValueError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SecretsManagerException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DecryptionFailure" -> DecryptionFailureDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedCall)
        else -> SecretsManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSecretValueOperationBody(builder: GetSecretValueResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ARN"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val SECRETBINARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("SecretBinary"))
    val SECRETSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecretString"))
    val VERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionId"))
    val VERSIONSTAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("VersionStages"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECRETBINARY_DESCRIPTOR)
        field(SECRETSTRING_DESCRIPTOR)
        field(VERSIONID_DESCRIPTOR)
        field(VERSIONSTAGES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECRETBINARY_DESCRIPTOR.index -> builder.secretBinary = deserializeString().decodeBase64Bytes()
                SECRETSTRING_DESCRIPTOR.index -> builder.secretString = deserializeString()
                VERSIONID_DESCRIPTOR.index -> builder.versionId = deserializeString()
                VERSIONSTAGES_DESCRIPTOR.index -> builder.versionStages =
                    deserializer.deserializeList(VERSIONSTAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
