// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class UpdateSecretVersionStageRequest private constructor(builder: Builder) {
    /**
     * The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.
     *
     * If the staging label is already attached to a different version of the secret, then you must also specify the `RemoveFromVersionId` parameter.
     */
    public val moveToVersionId: kotlin.String? = builder.moveToVersionId
    /**
     * The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.
     */
    public val removeFromVersionId: kotlin.String? = builder.removeFromVersionId
    /**
     * The ARN or the name of the secret with the version and staging labelsto modify.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId
    /**
     * The staging label to add to this version.
     */
    public val versionStage: kotlin.String? = builder.versionStage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretVersionStageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSecretVersionStageRequest(")
        append("moveToVersionId=$moveToVersionId,")
        append("removeFromVersionId=$removeFromVersionId,")
        append("secretId=$secretId,")
        append("versionStage=$versionStage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = moveToVersionId?.hashCode() ?: 0
        result = 31 * result + (removeFromVersionId?.hashCode() ?: 0)
        result = 31 * result + (secretId?.hashCode() ?: 0)
        result = 31 * result + (versionStage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateSecretVersionStageRequest

        if (moveToVersionId != other.moveToVersionId) return false
        if (removeFromVersionId != other.removeFromVersionId) return false
        if (secretId != other.secretId) return false
        if (versionStage != other.versionStage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretVersionStageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the version to add the staging label to. To remove a label from a version, then do not specify this parameter.
         *
         * If the staging label is already attached to a different version of the secret, then you must also specify the `RemoveFromVersionId` parameter.
         */
        public var moveToVersionId: kotlin.String? = null
        /**
         * The ID of the version that the staging label is to be removed from. If the staging label you are trying to attach to one version is already attached to a different version, then you must include this parameter and specify the version that the label is to be removed from. If the label is attached and you either do not specify this parameter, or the version ID does not match, then the operation fails.
         */
        public var removeFromVersionId: kotlin.String? = null
        /**
         * The ARN or the name of the secret with the version and staging labelsto modify.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null
        /**
         * The staging label to add to this version.
         */
        public var versionStage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretVersionStageRequest) : this() {
            this.moveToVersionId = x.moveToVersionId
            this.removeFromVersionId = x.removeFromVersionId
            this.secretId = x.secretId
            this.versionStage = x.versionStage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.UpdateSecretVersionStageRequest = UpdateSecretVersionStageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
