// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



public class GetSecretValueRequest private constructor(builder: Builder) {
    /**
     * The ARN or name of the secret to retrieve.
     *
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
     */
    public val secretId: kotlin.String? = builder.secretId
    /**
     * The unique identifier of the version of the secret to retrieve. If you include both this parameter and `VersionStage`, the two parameters must refer to the same secret version. If you don't specify either a `VersionStage` or `VersionId`, then Secrets Manager returns the `AWSCURRENT` version.
     *
     * This value is typically a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value with 32 hexadecimal digits.
     */
    public val versionId: kotlin.String? = builder.versionId
    /**
     * The staging label of the version of the secret to retrieve.
     *
     * Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and `VersionId`, the two parameters must refer to the same secret version. If you don't specify either a `VersionStage` or `VersionId`, Secrets Manager returns the `AWSCURRENT` version.
     */
    public val versionStage: kotlin.String? = builder.versionStage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.GetSecretValueRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSecretValueRequest(")
        append("secretId=$secretId,")
        append("versionId=$versionId,")
        append("versionStage=$versionStage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = secretId?.hashCode() ?: 0
        result = 31 * result + (versionId?.hashCode() ?: 0)
        result = 31 * result + (versionStage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSecretValueRequest

        if (secretId != other.secretId) return false
        if (versionId != other.versionId) return false
        if (versionStage != other.versionStage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.GetSecretValueRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN or name of the secret to retrieve.
         *
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See [Finding a secret from a partial ARN](https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen).
         */
        public var secretId: kotlin.String? = null
        /**
         * The unique identifier of the version of the secret to retrieve. If you include both this parameter and `VersionStage`, the two parameters must refer to the same secret version. If you don't specify either a `VersionStage` or `VersionId`, then Secrets Manager returns the `AWSCURRENT` version.
         *
         * This value is typically a [UUID-type](https://wikipedia.org/wiki/Universally_unique_identifier) value with 32 hexadecimal digits.
         */
        public var versionId: kotlin.String? = null
        /**
         * The staging label of the version of the secret to retrieve.
         *
         * Secrets Manager uses staging labels to keep track of different versions during the rotation process. If you include both this parameter and `VersionId`, the two parameters must refer to the same secret version. If you don't specify either a `VersionStage` or `VersionId`, Secrets Manager returns the `AWSCURRENT` version.
         */
        public var versionStage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.GetSecretValueRequest) : this() {
            this.secretId = x.secretId
            this.versionId = x.versionId
            this.versionStage = x.versionStage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.GetSecretValueRequest = GetSecretValueRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
