// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.secretsmanager.model



/**
 * Allows you to add filters when you use the search function in Secrets Manager. For more information, see [Find secrets in Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/manage_search-secret.html).
 */
public class Filter private constructor(builder: Builder) {
    /**
     * The following are keys you can use:
     * + **description**: Prefix match, not case-sensitive.
     * + **name**: Prefix match, case-sensitive.
     * + **tag-key**: Prefix match, case-sensitive.
     * + **tag-value**: Prefix match, case-sensitive.
     * + **primary-region**: Prefix match, case-sensitive.
     * + **owning-service**: Prefix match, case-sensitive.
     * + **all**: Breaks the filter value string into words and then searches all attributes for matches. Not case-sensitive.
     */
    public val key: aws.sdk.kotlin.services.secretsmanager.model.FilterNameStringType? = builder.key
    /**
     * The keyword to filter for.
     *
     * You can prefix your search value with an exclamation mark (`!`) in order to perform negation filters.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.secretsmanager.model.Filter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Filter(")
        append("key=$key,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Filter

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.secretsmanager.model.Filter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The following are keys you can use:
         * + **description**: Prefix match, not case-sensitive.
         * + **name**: Prefix match, case-sensitive.
         * + **tag-key**: Prefix match, case-sensitive.
         * + **tag-value**: Prefix match, case-sensitive.
         * + **primary-region**: Prefix match, case-sensitive.
         * + **owning-service**: Prefix match, case-sensitive.
         * + **all**: Breaks the filter value string into words and then searches all attributes for matches. Not case-sensitive.
         */
        public var key: aws.sdk.kotlin.services.secretsmanager.model.FilterNameStringType? = null
        /**
         * The keyword to filter for.
         *
         * You can prefix your search value with an exclamation mark (`!`) in order to perform negation filters.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.secretsmanager.model.Filter) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.secretsmanager.model.Filter = Filter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
